/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.BlockSet;
import nl.requios.effortlessbuilding.buildmodifier.UndoRedo;

public class AddUndoMessage {
    private final BlockPos coordinate;
    private final BlockState previousBlockState;
    private final BlockState newBlockState;

    public AddUndoMessage() {
        this.coordinate = BlockPos.f_121853_;
        this.previousBlockState = null;
        this.newBlockState = null;
    }

    public AddUndoMessage(BlockPos coordinate, BlockState previousBlockState, BlockState newBlockState) {
        this.coordinate = coordinate;
        this.previousBlockState = previousBlockState;
        this.newBlockState = newBlockState;
    }

    public static void encode(AddUndoMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.coordinate.m_123341_());
        buf.writeInt(message.coordinate.m_123342_());
        buf.writeInt(message.coordinate.m_123343_());
        buf.writeInt(Block.m_49956_((BlockState)message.previousBlockState));
        buf.writeInt(Block.m_49956_((BlockState)message.newBlockState));
    }

    public static AddUndoMessage decode(FriendlyByteBuf buf) {
        BlockPos coordinate = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        BlockState previousBlockState = Block.m_49803_((int)buf.readInt());
        BlockState newBlockState = Block.m_49803_((int)buf.readInt());
        return new AddUndoMessage(coordinate, previousBlockState, newBlockState);
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public BlockState getPreviousBlockState() {
        return this.previousBlockState;
    }

    public BlockState getNewBlockState() {
        return this.newBlockState;
    }

    public static class Handler {
        public static void handle(final AddUndoMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    Player player = EffortlessBuilding.proxy.getPlayerEntityFromContext(ctx);
                    UndoRedo.addUndo(player, new BlockSet((List<BlockPos>)new ArrayList<BlockPos>(){
                        {
                            this.add(message.getCoordinate());
                        }
                    }, (List<BlockState>)new ArrayList<BlockState>(){
                        {
                            this.add(message.getPreviousBlockState());
                        }
                    }, (List<BlockState>)new ArrayList<BlockState>(){
                        {
                            this.add(message.getNewBlockState());
                        }
                    }, new Vec3(0.0, 0.0, 0.0), message.getCoordinate(), message.getCoordinate()));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

