/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.network.BlockPlacedMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.proxy.ClientProxy;

public class RequestLookAtMessage {
    private final boolean placeStartPos;

    public RequestLookAtMessage() {
        this.placeStartPos = false;
    }

    public RequestLookAtMessage(boolean placeStartPos) {
        this.placeStartPos = placeStartPos;
    }

    public static void encode(RequestLookAtMessage message, FriendlyByteBuf buf) {
        buf.writeBoolean(message.placeStartPos);
    }

    public static RequestLookAtMessage decode(FriendlyByteBuf buf) {
        boolean placeStartPos = buf.readBoolean();
        return new RequestLookAtMessage(placeStartPos);
    }

    public boolean getPlaceStartPos() {
        return this.placeStartPos;
    }

    public static class Handler {
        public static void handle(RequestLookAtMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    Player player = EffortlessBuilding.proxy.getPlayerEntityFromContext(ctx);
                    if (ClientProxy.previousLookAt.m_6662_() == HitResult.Type.BLOCK) {
                        PacketHandler.INSTANCE.sendToServer((Object)new BlockPlacedMessage((BlockHitResult)ClientProxy.previousLookAt, message.getPlaceStartPos()));
                    } else {
                        PacketHandler.INSTANCE.sendToServer((Object)new BlockPlacedMessage());
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

