/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.BuildConfig;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL13;

public class BuildRenderTypes
extends RenderType {
    public static ResourceLocation shaderMaskTextureLocation = new ResourceLocation("effortlessbuilding", "textures/shader_mask.png");
    public static final RenderType LINES;
    public static final RenderType PLANES;
    public static ShaderInstance dissolveShaderInstance;
    private static final RenderStateShard.ShaderStateShard RENDERTYPE_DISSOLVE_SHADER;
    private static final int maskTextureIndex = 7;

    public BuildRenderTypes(String p_173178_, VertexFormat p_173179_, VertexFormat.Mode p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
        super(p_173178_, p_173179_, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
    }

    public static RenderType getBlockPreviewRenderType(float dissolve, BlockPos blockPos, BlockPos firstPos, BlockPos secondPos, boolean red) {
        Boolean useShaders = (Boolean)BuildConfig.visuals.useShaders.get();
        String stateName = "eb_texturing_" + dissolve + "_" + blockPos + "_" + firstPos + "_" + secondPos + "_" + red;
        RenderStateShard.TexturingStateShard MY_TEXTURING = new RenderStateShard.TexturingStateShard(stateName, () -> {
            BuildRenderTypes.setShaderParameters(dissolveShaderInstance, dissolve, Vec3.m_82528_((Vec3i)blockPos), Vec3.m_82528_((Vec3i)firstPos), Vec3.m_82528_((Vec3i)secondPos), blockPos == secondPos, red);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        }, () -> {});
        RenderType.CompositeState renderState = RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_DISSOLVE_SHADER).m_110683_(MY_TEXTURING).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(shaderMaskTextureLocation, false, false)).m_110685_(f_110139_).m_110661_(new RenderStateShard.CullStateShard(true)).m_110671_(new RenderStateShard.LightmapStateShard(false)).m_110677_(new RenderStateShard.OverlayStateShard(false)).m_110691_(true);
        String name = "eb_block_previews_" + dissolve + "_" + blockPos + "_" + firstPos + "_" + secondPos + "_" + red;
        return RenderType.m_173215_((String)name, (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)renderState);
    }

    private static void setShaderParameters(ShaderInstance shader, float dissolve, Vec3 blockpos, Vec3 firstpos, Vec3 secondpos, boolean highlight, boolean red) {
        Uniform percentileUniform = shader.m_173348_("dissolve");
        Uniform highlightUniform = shader.m_173348_("highlight");
        Uniform redUniform = shader.m_173348_("red");
        Uniform blockposUniform = shader.m_173348_("blockpos");
        Uniform firstposUniform = shader.m_173348_("firstpos");
        Uniform secondposUniform = shader.m_173348_("secondpos");
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_157456_((int)7, (ResourceLocation)shaderMaskTextureLocation);
        percentileUniform.m_5985_(dissolve);
        highlightUniform.m_142617_(highlight ? 1 : 0);
        redUniform.m_142617_(red ? 1 : 0);
        blockposUniform.m_5889_((float)blockpos.f_82479_, (float)blockpos.f_82480_, (float)blockpos.f_82481_);
        firstposUniform.m_5889_((float)firstpos.f_82479_, (float)firstpos.f_82480_, (float)firstpos.f_82481_);
        secondposUniform.m_5889_((float)secondpos.f_82479_, (float)secondpos.f_82480_, (float)secondpos.f_82481_);
    }

    public static void glActiveTexture(int texture) {
        if (GL.getCapabilities().GL_ARB_multitexture && !GL.getCapabilities().OpenGL13) {
            ARBMultitexture.glActiveTextureARB((int)texture);
        } else {
            GL13.glActiveTexture((int)texture);
        }
    }

    static {
        RENDERTYPE_DISSOLVE_SHADER = new RenderStateShard.ShaderStateShard(() -> dissolveShaderInstance);
        RenderStateShard.LineStateShard LINE = new RenderStateShard.LineStateShard(OptionalDouble.of(2.0));
        int INITIAL_BUFFER_SIZE = 128;
        RenderType.CompositeState renderState = RenderType.CompositeState.m_110628_().m_110673_(LINE).m_173292_(RenderStateShard.f_173095_).m_110669_(f_110119_).m_110685_(f_110139_).m_173290_(RenderStateShard.f_110147_).m_110663_(RenderStateShard.f_110111_).m_110671_(RenderStateShard.f_110153_).m_110687_(f_110114_).m_110661_(RenderStateShard.f_110110_).m_110691_(false);
        LINES = RenderType.m_173215_((String)"eb_lines", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)128, (boolean)false, (boolean)false, (RenderType.CompositeState)renderState);
        renderState = RenderType.CompositeState.m_110628_().m_110673_(LINE).m_173292_(RenderStateShard.f_173095_).m_110669_(f_110119_).m_110685_(f_110139_).m_173290_(RenderStateShard.f_110147_).m_110663_(RenderStateShard.f_110111_).m_110671_(RenderStateShard.f_110153_).m_110687_(f_110115_).m_110661_(RenderStateShard.f_110110_).m_110691_(false);
        PLANES = RenderType.m_173215_((String)"eb_planes", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)128, (boolean)false, (boolean)false, (RenderType.CompositeState)renderState);
    }

    private class ShaderInfo {
        float dissolve;
        Vec3 blockPos;
        Vec3 firstPos;
        Vec3 secondPos;
        boolean red;

        public ShaderInfo(float dissolve, Vec3 blockPos, Vec3 firstPos, Vec3 secondPos, boolean red) {
            this.dissolve = dissolve;
            this.blockPos = blockPos;
            this.firstPos = firstPos;
            this.secondPos = secondPos;
            this.red = red;
        }
    }
}

