/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.gui.buildmode.RadialMenu;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.network.ModeActionMessage;
import nl.requios.effortlessbuilding.network.ModeSettingsMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.proxy.ClientProxy;
import nl.requios.effortlessbuilding.render.BlockPreviewRenderer;
import nl.requios.effortlessbuilding.render.BuildRenderTypes;
import nl.requios.effortlessbuilding.render.ModifierRenderer;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderHandler {
    @SubscribeEvent
    public static void onRender(RenderWorldLastEvent event) {
        if (event.getPhase() != EventPriority.NORMAL) {
            return;
        }
        PoseStack matrixStack = event.getMatrixStack();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)bufferBuilder);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings((Player)player);
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((Player)player);
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        ModifierRenderer.render(matrixStack, renderTypeBuffer, modifierSettings);
        BlockPreviewRenderer.render(matrixStack, renderTypeBuffer, (Player)player, modifierSettings, modeSettings);
        matrixStack.m_85849_();
    }

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type == RenderGameOverlayEvent.ElementType.ALL) {
            boolean wasVisible = RadialMenu.instance.isVisible();
            if (ClientProxy.keyBindings[3].m_90857_()) {
                if (ReachHelper.getMaxReach((Player)player) > 0) {
                    RadialMenu.instance.actionUsed = false;
                    RadialMenu.instance.raiseVisibility();
                } else if (ClientProxy.keyBindings[3].m_90859_()) {
                    EffortlessBuilding.log((Player)player, "Build modes are disabled until your reach has increased. Increase your reach with craftable reach upgrades.");
                }
            } else {
                if (!RadialMenu.instance.actionUsed) {
                    ModeOptions.ActionEnum action;
                    ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings((Player)player);
                    if (RadialMenu.instance.switchTo != null) {
                        RenderHandler.playRadialMenuSound();
                        modeSettings.setBuildMode(RadialMenu.instance.switchTo);
                        ModeSettingsManager.setModeSettings((Player)player, modeSettings);
                        PacketHandler.INSTANCE.sendToServer((Object)new ModeSettingsMessage(modeSettings));
                        EffortlessBuilding.log((Player)player, I18n.m_118938_((String)modeSettings.getBuildMode().name, (Object[])new Object[0]), true);
                    }
                    if ((action = RadialMenu.instance.doAction) != null) {
                        ModeOptions.performAction((Player)player, action);
                        PacketHandler.INSTANCE.sendToServer((Object)new ModeActionMessage(action));
                    }
                    RenderHandler.playRadialMenuSound();
                }
                RadialMenu.instance.actionUsed = true;
                RadialMenu.instance.decreaseVisibility();
            }
            if (RadialMenu.instance.isVisible()) {
                int scaledWidth = mc.m_91268_().m_85445_();
                int scaledHeight = mc.m_91268_().m_85446_();
                RadialMenu.instance.configure(scaledWidth, scaledHeight);
                if (!wasVisible) {
                    mc.f_91067_.m_91602_();
                }
                if (mc.f_91067_.m_91600_()) {
                    KeyMapping.m_90847_();
                }
                int mouseX = (int)mc.f_91067_.m_91589_() * scaledWidth / mc.m_91268_().m_85441_();
                int mouseY = scaledHeight - (int)mc.f_91067_.m_91594_() * scaledHeight / mc.m_91268_().m_85442_() - 1;
                ForgeHooksClient.drawScreen((Screen)RadialMenu.instance, (PoseStack)event.getMatrixStack(), (int)mouseX, (int)mouseY, (float)event.getPartialTicks());
            } else if (wasVisible && RadialMenu.instance.doAction != ModeOptions.ActionEnum.OPEN_MODIFIER_SETTINGS && RadialMenu.instance.doAction != ModeOptions.ActionEnum.OPEN_PLAYER_SETTINGS) {
                mc.f_91067_.m_91601_();
            }
        }
    }

    public static void playRadialMenuSound() {
        float volume = 0.1f;
        SimpleSoundInstance sound = new SimpleSoundInstance(SoundEvents.f_12490_, SoundSource.MASTER, 0.1f, 1.0f, Minecraft.m_91087_().f_91074_.m_142538_());
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
    }

    protected static VertexConsumer beginLines(MultiBufferSource.BufferSource renderTypeBuffer) {
        return renderTypeBuffer.m_6299_(BuildRenderTypes.LINES);
    }

    protected static void endLines(MultiBufferSource.BufferSource renderTypeBuffer) {
        renderTypeBuffer.m_109911_();
    }

    protected static VertexConsumer beginPlanes(MultiBufferSource.BufferSource renderTypeBuffer) {
        return renderTypeBuffer.m_6299_(BuildRenderTypes.PLANES);
    }

    protected static void endPlanes(MultiBufferSource.BufferSource renderTypeBuffer) {
        renderTypeBuffer.m_109911_();
    }

    protected static void renderBlockPreview(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffer, BlockRenderDispatcher dispatcher, BlockPos blockPos, BlockState blockState, float dissolve, BlockPos firstPos, BlockPos secondPos, boolean red) {
        if (blockState == null) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        matrixStack.m_85837_((double)-0.01f, (double)-0.01f, (double)-0.01f);
        matrixStack.m_85841_(1.02f, 1.02f, 1.02f);
        RenderType blockPreviewRenderType = BuildRenderTypes.getBlockPreviewRenderType(dissolve, blockPos, firstPos, secondPos, red);
        VertexConsumer buffer = renderTypeBuffer.m_6299_(blockPreviewRenderType);
        try {
            BakedModel model = dispatcher.m_110910_(blockState);
            dispatcher.m_110937_().renderModel(matrixStack.m_85850_(), buffer, blockState, model, 1.0f, 1.0f, 1.0f, 0, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
        }
        catch (NullPointerException e) {
            EffortlessBuilding.logger.warn("RenderHandler::renderBlockPreview cannot render " + blockState.m_60734_().toString());
            matrixStack.m_85849_();
            renderTypeBuffer.m_109911_();
            VertexConsumer lineBuffer = RenderHandler.beginLines(renderTypeBuffer);
            RenderHandler.renderBlockOutline(matrixStack, lineBuffer, blockPos, new Vec3(1.0, 1.0, 1.0));
            RenderHandler.endLines(renderTypeBuffer);
            buffer = renderTypeBuffer.m_6299_(Sheets.m_110792_());
            matrixStack.m_85836_();
        }
        renderTypeBuffer.m_109911_();
        matrixStack.m_85849_();
    }

    protected static void renderBlockOutline(PoseStack matrixStack, VertexConsumer buffer, BlockPos pos, Vec3 color) {
        RenderHandler.renderBlockOutline(matrixStack, buffer, pos, pos, color);
    }

    protected static void renderBlockOutline(PoseStack matrixStack, VertexConsumer buffer, BlockPos pos1, BlockPos pos2, Vec3 color) {
        AABB aabb = new AABB(pos1, pos2.m_142082_(1, 1, 1)).m_82400_((double)0.002f);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffer, (AABB)aabb, (float)((float)color.f_82479_), (float)((float)color.f_82480_), (float)((float)color.f_82481_), (float)0.4f);
    }

    protected static void renderBlockOutline(PoseStack matrixStack, VertexConsumer buffer, BlockPos pos, VoxelShape collisionShape, Vec3 color) {
        LevelRenderer.m_109654_((PoseStack)matrixStack, (VertexConsumer)buffer, (VoxelShape)collisionShape, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (float)((float)color.f_82479_), (float)((float)color.f_82480_), (float)((float)color.f_82481_), (float)0.4f);
    }
}

