/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleList;
import me.jellysquid.mods.lithium.common.shapes.VoxelShapeSimpleCube;
import me.jellysquid.mods.sodium.mixin.shapes.specialized_shapes.VoxelShapeAccessorMixin;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapePart;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class VoxelShapeMatchesAnywhere {
    public static void cuboidMatchesAnywhere(VoxelShape shapeA, VoxelShape shapeB, IBooleanFunction predicate, CallbackInfoReturnable<Boolean> cir) {
        if (shapeA instanceof VoxelShapeSimpleCube && shapeB instanceof VoxelShapeSimpleCube) {
            if (((VoxelShapeSimpleCube)shapeA).isTiny || ((VoxelShapeSimpleCube)shapeB).isTiny) {
                return;
            }
            if (predicate.apply(true, true)) {
                if (VoxelShapeMatchesAnywhere.intersects((VoxelShapeSimpleCube)shapeA, (VoxelShapeSimpleCube)shapeB)) {
                    cir.setReturnValue((Object)true);
                    return;
                }
                cir.setReturnValue((Object)(predicate.apply(true, false) || predicate.apply(false, true) ? 1 : 0));
            } else {
                if (predicate.apply(true, false) && VoxelShapeMatchesAnywhere.exceedsShape((VoxelShapeSimpleCube)shapeA, (VoxelShapeSimpleCube)shapeB)) {
                    cir.setReturnValue((Object)true);
                    return;
                }
                if (predicate.apply(false, true) && VoxelShapeMatchesAnywhere.exceedsShape((VoxelShapeSimpleCube)shapeB, (VoxelShapeSimpleCube)shapeA)) {
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
            cir.setReturnValue((Object)false);
        } else if (shapeA instanceof VoxelShapeSimpleCube || shapeB instanceof VoxelShapeSimpleCube) {
            VoxelShape otherShape;
            VoxelShapeSimpleCube simpleCube = (VoxelShapeSimpleCube)(shapeA instanceof VoxelShapeSimpleCube ? shapeA : shapeB);
            VoxelShape voxelShape = otherShape = simpleCube == shapeA ? shapeB : shapeA;
            if (simpleCube.isTiny || VoxelShapeMatchesAnywhere.isTiny(otherShape)) {
                return;
            }
            boolean acceptSimpleCubeAlone = predicate.apply(shapeA == simpleCube, shapeB == simpleCube);
            if (acceptSimpleCubeAlone && VoxelShapeMatchesAnywhere.exceedsCube(simpleCube, otherShape.func_197762_b(Direction.Axis.X), otherShape.func_197762_b(Direction.Axis.Y), otherShape.func_197762_b(Direction.Axis.Z), otherShape.func_197758_c(Direction.Axis.X), otherShape.func_197758_c(Direction.Axis.Y), otherShape.func_197758_c(Direction.Axis.Z))) {
                cir.setReturnValue((Object)true);
                return;
            }
            boolean acceptAnd = predicate.apply(true, true);
            boolean acceptOtherShapeAlone = predicate.apply(shapeA == otherShape, shapeB == otherShape);
            VoxelShapePart voxelSet = otherShape.field_197768_g;
            DoubleList pointPositionsX = ((VoxelShapeAccessorMixin)otherShape).igetValues(Direction.Axis.X);
            DoubleList pointPositionsY = ((VoxelShapeAccessorMixin)otherShape).igetValues(Direction.Axis.Y);
            DoubleList pointPositionsZ = ((VoxelShapeAccessorMixin)otherShape).igetValues(Direction.Axis.Z);
            int xMax = voxelSet.func_199624_b(Direction.Axis.X);
            int yMax = voxelSet.func_199624_b(Direction.Axis.Y);
            int zMax = voxelSet.func_199624_b(Direction.Axis.Z);
            double simpleCubeMaxX = simpleCube.func_197758_c(Direction.Axis.X);
            double simpleCubeMinX = simpleCube.func_197762_b(Direction.Axis.X);
            double simpleCubeMaxY = simpleCube.func_197758_c(Direction.Axis.Y);
            double simpleCubeMinY = simpleCube.func_197762_b(Direction.Axis.Y);
            double simpleCubeMaxZ = simpleCube.func_197758_c(Direction.Axis.Z);
            double simpleCubeMinZ = simpleCube.func_197762_b(Direction.Axis.Z);
            for (int x = voxelSet.func_199623_a(Direction.Axis.X); x < xMax; ++x) {
                boolean simpleCubeIntersectsXSlice;
                boolean bl = simpleCubeIntersectsXSlice = simpleCubeMaxX - 1.0E-7 > pointPositionsX.getDouble(x) && simpleCubeMinX < pointPositionsX.getDouble(x + 1) - 1.0E-7;
                if (!acceptOtherShapeAlone && !simpleCubeIntersectsXSlice) continue;
                boolean xSliceExceedsCube = !(!acceptOtherShapeAlone || simpleCubeMaxX >= pointPositionsX.getDouble(x + 1) - 1.0E-7 && simpleCubeMinX - 1.0E-7 <= pointPositionsX.getDouble(x));
                for (int y = voxelSet.func_199623_a(Direction.Axis.Y); y < yMax; ++y) {
                    boolean simpleCubeIntersectsYSlice;
                    boolean bl2 = simpleCubeIntersectsYSlice = simpleCubeMaxY - 1.0E-7 > pointPositionsY.getDouble(y) && simpleCubeMinY < pointPositionsY.getDouble(y + 1) - 1.0E-7;
                    if (!acceptOtherShapeAlone && !simpleCubeIntersectsYSlice) continue;
                    boolean ySliceExceedsCube = !(!acceptOtherShapeAlone || simpleCubeMaxY >= pointPositionsY.getDouble(y + 1) - 1.0E-7 && simpleCubeMinY - 1.0E-7 <= pointPositionsY.getDouble(y));
                    for (int z = voxelSet.func_199623_a(Direction.Axis.Z); z < zMax; ++z) {
                        boolean s;
                        boolean simpleCubeIntersectsZSlice;
                        boolean bl3 = simpleCubeIntersectsZSlice = simpleCubeMaxZ - 1.0E-7 > pointPositionsZ.getDouble(z) && simpleCubeMinZ < pointPositionsZ.getDouble(z + 1) - 1.0E-7;
                        if (!acceptOtherShapeAlone && !simpleCubeIntersectsZSlice) continue;
                        boolean zSliceExceedsCube = !(!acceptOtherShapeAlone || simpleCubeMaxZ >= pointPositionsZ.getDouble(z + 1) - 1.0E-7 && simpleCubeMinZ - 1.0E-7 <= pointPositionsZ.getDouble(z));
                        boolean o = voxelSet.func_197818_c(x, y, z);
                        boolean bl4 = s = simpleCubeIntersectsXSlice && simpleCubeIntersectsYSlice && simpleCubeIntersectsZSlice;
                        if (!(acceptAnd && o && s || acceptSimpleCubeAlone && !o && s) && (!acceptOtherShapeAlone || !o || !xSliceExceedsCube && !ySliceExceedsCube && !zSliceExceedsCube)) continue;
                        cir.setReturnValue((Object)true);
                        return;
                    }
                }
            }
            cir.setReturnValue((Object)false);
        }
    }

    private static boolean isTiny(VoxelShape shapeA) {
        return shapeA.func_197762_b(Direction.Axis.X) > shapeA.func_197758_c(Direction.Axis.X) - 3.0E-7 || shapeA.func_197762_b(Direction.Axis.Y) > shapeA.func_197758_c(Direction.Axis.Y) - 3.0E-7 || shapeA.func_197762_b(Direction.Axis.Z) > shapeA.func_197758_c(Direction.Axis.Z) - 3.0E-7;
    }

    private static boolean exceedsCube(VoxelShapeSimpleCube a, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return a.func_197762_b(Direction.Axis.X) < minX - 1.0E-7 || a.func_197758_c(Direction.Axis.X) > maxX + 1.0E-7 || a.func_197762_b(Direction.Axis.Y) < minY - 1.0E-7 || a.func_197758_c(Direction.Axis.Y) > maxY + 1.0E-7 || a.func_197762_b(Direction.Axis.Z) < minZ - 1.0E-7 || a.func_197758_c(Direction.Axis.Z) > maxZ + 1.0E-7;
    }

    private static boolean exceedsShape(VoxelShapeSimpleCube a, VoxelShapeSimpleCube b) {
        return a.func_197762_b(Direction.Axis.X) < b.func_197762_b(Direction.Axis.X) - 1.0E-7 || a.func_197758_c(Direction.Axis.X) > b.func_197758_c(Direction.Axis.X) + 1.0E-7 || a.func_197762_b(Direction.Axis.Y) < b.func_197762_b(Direction.Axis.Y) - 1.0E-7 || a.func_197758_c(Direction.Axis.Y) > b.func_197758_c(Direction.Axis.Y) + 1.0E-7 || a.func_197762_b(Direction.Axis.Z) < b.func_197762_b(Direction.Axis.Z) - 1.0E-7 || a.func_197758_c(Direction.Axis.Z) > b.func_197758_c(Direction.Axis.Z) + 1.0E-7;
    }

    private static boolean intersects(VoxelShapeSimpleCube a, VoxelShapeSimpleCube b) {
        return a.func_197762_b(Direction.Axis.X) < b.func_197758_c(Direction.Axis.X) - 1.0E-7 && a.func_197758_c(Direction.Axis.X) > b.func_197762_b(Direction.Axis.X) + 1.0E-7 && a.func_197762_b(Direction.Axis.Y) < b.func_197758_c(Direction.Axis.Y) - 1.0E-7 && a.func_197758_c(Direction.Axis.Y) > b.func_197762_b(Direction.Axis.Y) + 1.0E-7 && a.func_197762_b(Direction.Axis.Z) < b.func_197758_c(Direction.Axis.Z) - 1.0E-7 && a.func_197758_c(Direction.Axis.Z) > b.func_197762_b(Direction.Axis.Z) + 1.0E-7;
    }
}

