/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.util.thread;

import com.google.common.collect.Queues;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.concurrent.ITaskQueue;

public class ArrayPrioritizedTaskQueue
implements ITaskQueue<ITaskQueue.RunnableWithPriority, Runnable> {
    private final Queue<Runnable>[] queues;
    private final AtomicInteger size;

    public ArrayPrioritizedTaskQueue(int count) {
        this.queues = new Queue[count];
        for (int i = 0; i < count; ++i) {
            this.queues[i] = Queues.newConcurrentLinkedQueue();
        }
        this.size = new AtomicInteger(0);
    }

    public Runnable poll() {
        for (Queue<Runnable> queue : this.queues) {
            Runnable task = queue.poll();
            if (task == null) continue;
            this.size.decrementAndGet();
            return task;
        }
        return null;
    }

    public boolean enqueue(ITaskQueue.RunnableWithPriority task) {
        this.size.incrementAndGet();
        Queue<Runnable> queue = this.queues[task.func_219950_a()];
        queue.add((Runnable)task);
        return true;
    }

    public boolean func_219946_b() {
        return this.size.get() <= 0;
    }
}

