/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.interests.iterator;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.jellysquid.mods.lithium.common.util.tuples.SortedPointOfInterest;
import me.jellysquid.mods.lithium.common.world.interests.PointOfInterestSetExtended;
import me.jellysquid.mods.lithium.common.world.interests.RegionBasedStorageSectionExtended;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestData;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;

public class NearbyPointOfInterestStream
extends Spliterators.AbstractSpliterator<PointOfInterest> {
    private final RegionBasedStorageSectionExtended<PointOfInterestData> storage;
    private final Predicate<PointOfInterestType> typeSelector;
    private final PointOfInterestManager.Status occupationStatus;
    private final List<ChunkPos> chunks;
    private final List<SortedPointOfInterest> points;
    private final Consumer<PointOfInterest> collector;
    private int chunkIndex;
    private int pointIndex;

    public NearbyPointOfInterestStream(Predicate<PointOfInterestType> typeSelector, PointOfInterestManager.Status status, Predicate<PointOfInterest> predicate, BlockPos origin, int radius, RegionBasedStorageSectionExtended<PointOfInterestData> storage) {
        super(Long.MAX_VALUE, 16);
        this.storage = storage;
        this.chunkIndex = 0;
        this.pointIndex = 0;
        this.points = new ArrayList<SortedPointOfInterest>();
        this.occupationStatus = status;
        this.typeSelector = typeSelector;
        this.collector = point -> {
            if (predicate.test((PointOfInterest)point)) {
                this.points.add(new SortedPointOfInterest((PointOfInterest)point, origin));
            }
        };
        this.chunks = NearbyPointOfInterestStream.initChunkPositions(origin, radius);
    }

    private static List<ChunkPos> initChunkPositions(BlockPos origin, int radius) {
        ChunkPos originChunk = new ChunkPos(origin);
        int minChunkX = origin.func_177958_n() - radius - 1 >> 4;
        int minChunkZ = origin.func_177952_p() - radius - 1 >> 4;
        int maxChunkX = origin.func_177958_n() + radius + 1 >> 4;
        int maxChunkZ = origin.func_177952_p() + radius + 1 >> 4;
        ObjectArrayList list = new ObjectArrayList();
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                list.add(new ChunkPos(x, z));
            }
        }
        list.sort(Comparator.comparingDouble(arg_0 -> ((ChunkPos)originChunk).func_226661_a_(arg_0)));
        return list;
    }

    @Override
    public boolean tryAdvance(Consumer<? super PointOfInterest> action) {
        if (this.pointIndex < this.points.size()) {
            return this.tryAdvancePoint(action);
        }
        while (this.chunkIndex < this.chunks.size()) {
            ChunkPos chunkPos = this.chunks.get(this.chunkIndex);
            ++this.chunkIndex;
            this.points.clear();
            this.pointIndex = 0;
            for (PointOfInterestData set : this.storage.getInChunkColumn(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
                ((PointOfInterestSetExtended)set).collectMatchingPoints(this.typeSelector, this.occupationStatus, this.collector);
            }
            if (this.points.isEmpty()) continue;
            this.points.sort((o1, o2) -> {
                int dist = Double.compare(o1.distance, o2.distance);
                if (dist != 0) {
                    return dist;
                }
                return Integer.compare(o1.getY(), o2.getY());
            });
            return this.tryAdvancePoint(action);
        }
        return false;
    }

    private boolean tryAdvancePoint(Consumer<? super PointOfInterest> action) {
        SortedPointOfInterest next = this.points.get(this.pointIndex++);
        action.accept((PointOfInterest)next.poi);
        return this.pointIndex < this.points.size() || this.chunkIndex < this.chunks.size();
    }
}

