/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.layer;

import me.jellysquid.mods.lithium.common.world.layer.CloneableContext;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.traits.IAreaTransformer0;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.minecraft.world.gen.layer.traits.IAreaTransformer2;

public final class CachedLocalLayerFactory {
    public static <R extends IArea> IAreaFactory<R> createInit(IAreaTransformer0 layer, CloneableContext<R> context) {
        return CachedLocalLayerFactory.createMemoized(() -> {
            IExtendedNoiseRandom clonedContext = context.cloneContext();
            return clonedContext.func_212861_a_((x, z) -> {
                clonedContext.func_202698_a((long)x, (long)z);
                return layer.func_215735_a((INoiseRandom)clonedContext, x, z);
            });
        });
    }

    public static <R extends IArea> IAreaFactory<R> createParented(IAreaTransformer1 layer, CloneableContext<R> context, IAreaFactory<R> parent) {
        return CachedLocalLayerFactory.createMemoized(() -> {
            IExtendedNoiseRandom clonedContext = context.cloneContext();
            IArea parentSampler = parent.make();
            return clonedContext.func_212859_a_((x, z) -> {
                clonedContext.func_202698_a((long)x, (long)z);
                return layer.func_215728_a(clonedContext, parentSampler, x, z);
            }, parentSampler);
        });
    }

    public static <R extends IArea> IAreaFactory<R> createMerging(IAreaTransformer2 layer, CloneableContext<R> context, IAreaFactory<R> layer1, IAreaFactory<R> layer2) {
        return CachedLocalLayerFactory.createMemoized(() -> {
            IExtendedNoiseRandom clonedContext = context.cloneContext();
            IArea sampler1 = layer1.make();
            IArea sampler2 = layer2.make();
            return clonedContext.func_212860_a_((x, z) -> {
                clonedContext.func_202698_a((long)x, (long)z);
                return layer.func_215723_a((INoiseRandom)clonedContext, sampler1, sampler2, x, z);
            }, sampler1, sampler2);
        });
    }

    private static <R extends IArea> IAreaFactory<R> createMemoized(IAreaFactory<R> factory) {
        ThreadLocal<IArea> threadLocal = ThreadLocal.withInitial(() -> factory.make());
        return threadLocal::get;
    }
}

