/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.noise;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.SimplexNoiseGenerator;

public class SimplexNoiseCache {
    private static final int GRID_SIZE = 2;
    private static final float MIN = -100.0f;
    private static final float MAX = 80.0f;
    private static final float ISLAND_RADIUS = 100.0f;
    private static final int CACHE_SIZE = 8192;
    private final int mask;
    private final long[] keys;
    private final float[] values;
    private final SimplexNoiseGenerator sampler;

    public SimplexNoiseCache(SimplexNoiseGenerator sampler) {
        this.sampler = sampler;
        this.mask = 8191;
        this.keys = new long[8192];
        Arrays.fill(this.keys, Long.MIN_VALUE);
        this.values = new float[8192];
    }

    private float getDistanceFactor(int x, int z) {
        long key = ChunkPos.func_77272_a((int)x, (int)z);
        int idx = (int)HashCommon.mix((long)key) & this.mask;
        if (this.keys[idx] == key) {
            return this.values[idx];
        }
        float value = -1.0f;
        long lx = x;
        long lz = z;
        long distanceFromOriginSq = lx * lx + lz * lz;
        if (distanceFromOriginSq > 4096L && this.sampler.func_151605_a((double)x, (double)z) < -0.9) {
            value = ((float)MathHelper.func_76130_a((int)x) * 3439.0f + (float)MathHelper.func_76130_a((int)z) * 147.0f) % 13.0f + 9.0f;
        }
        this.keys[idx] = key;
        this.values[idx] = value;
        return value;
    }

    public float getNoiseAt(int x, int z) {
        int gridX = x / 2;
        int gridZ = z / 2;
        int gridOriginX = x % 2;
        int gridOriginZ = z % 2;
        float density = 100.0f - MathHelper.func_76129_c((float)(x * x + z * z)) * 8.0f;
        if (density >= 80.0f) {
            return 80.0f;
        }
        for (int offsetX = -12; offsetX <= 12; ++offsetX) {
            for (int offsetZ = -12; offsetZ <= 12; ++offsetZ) {
                float deltaZ;
                float deltaX;
                float scaledDistance;
                float densityHere;
                int globalGridX = gridX + offsetX;
                int globalGridZ = gridZ + offsetZ;
                float distanceFactor = this.getDistanceFactor(globalGridX, globalGridZ);
                if (distanceFactor == -1.0f || !((densityHere = 100.0f - (scaledDistance = MathHelper.func_76129_c((float)((deltaX = (float)(gridOriginX - offsetX * 2)) * deltaX + (deltaZ = (float)(gridOriginZ - offsetZ * 2)) * deltaZ)) * distanceFactor)) > density)) continue;
                if (densityHere >= 80.0f) {
                    return 80.0f;
                }
                density = densityHere;
            }
        }
        return Math.max(density, -100.0f);
    }
}

