/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.shader;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import me.jellysquid.mods.sodium.client.gl.GlObject;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderBindingPoint;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20C;

public abstract class GlProgram
extends GlObject {
    private static final Logger LOGGER = LogManager.getLogger(GlProgram.class);
    private final ResourceLocation name;

    protected GlProgram(RenderDevice owner, ResourceLocation name, int program) {
        super(owner);
        this.name = name;
        this.setHandle(program);
    }

    public static Builder builder(ResourceLocation ResourceLocation2) {
        return new Builder(ResourceLocation2);
    }

    public void bind() {
        GL20C.glUseProgram((int)this.handle());
    }

    public void unbind() {
        GL20C.glUseProgram((int)0);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public int getUniformLocation(String name) {
        int index = GL20C.glGetUniformLocation((int)this.handle(), (CharSequence)name);
        if (index < 0) {
            throw new NullPointerException("No uniform exists with name: " + name);
        }
        return index;
    }

    public void delete() {
        GL20C.glDeleteProgram((int)this.handle());
        this.invalidateHandle();
    }

    public static interface ProgramFactory<P extends GlProgram> {
        public P create(ResourceLocation var1, int var2);
    }

    public static class Builder {
        private final ResourceLocation name;
        private final int program;
        private final IntArrayList shaderIds;

        public Builder(ResourceLocation name) {
            this.name = name;
            this.shaderIds = new IntArrayList();
            this.program = GL20C.glCreateProgram();
        }

        public Builder attachShader(GlShader shader) {
            GL20C.glAttachShader((int)this.program, (int)shader.handle());
            return this;
        }

        public <P extends GlProgram> P build(ProgramFactory<P> factory) {
            GL20C.glLinkProgram((int)this.program);
            String log = GL20C.glGetProgramInfoLog((int)this.program);
            if (!log.isEmpty()) {
                LOGGER.warn("Program link log for " + this.name + ": " + log);
            }
            int result = GL20C.glGetProgrami((int)this.program, (int)35714);
            GL20C.glValidateProgram((int)this.program);
            if ((result &= GL20C.glGetProgrami((int)this.program, (int)35715)) != 1) {
                throw new RuntimeException("Shader program linking failed, see log for details");
            }
            this.shaderIds.forEach(id -> GL20C.glDetachShader((int)this.program, (int)id));
            return factory.create(this.name, this.program);
        }

        public Builder bindAttribute(String name, ShaderBindingPoint binding) {
            GL20C.glBindAttribLocation((int)this.program, (int)binding.getGenericAttributeIndex(), (CharSequence)name);
            return this;
        }
    }
}

