/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.ChunkDrawCallBatcher;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.StructBuffer;
import org.lwjgl.system.MemoryUtil;

public class IndirectParameterBufferVector
extends StructBuffer {
    private static final int INT_SIZE = 4;
    private IntBuffer intBuffer;

    protected IndirectParameterBufferVector(int bytes) {
        super(bytes, 4);
        this.intBuffer = this.buffer.asIntBuffer();
    }

    public static IndirectParameterBufferVector create(int capacity) {
        return new IndirectParameterBufferVector(capacity);
    }

    public void begin() {
        this.intBuffer.clear();
    }

    public void end() {
        this.intBuffer.flip();
    }

    public void pushBatchCount(ChunkDrawCallBatcher batch) {
        int drawCount = batch.getCount();
        if (this.buffer.remaining() < 4) {
            this.growBuffer(4);
        }
        this.intBuffer.put(drawCount);
    }

    protected void growBuffer(int n) {
        this.buffer = MemoryUtil.memRealloc((ByteBuffer)this.buffer, (int)Math.max(this.buffer.capacity() * 2, this.buffer.capacity() + n));
        this.intBuffer = this.buffer.asIntBuffer();
    }
}

