/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.cull;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.List;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ChunkRayTracer {
    private final Object2BooleanMap<BlockPos> blockStateCache;
    private final World world;

    public ChunkRayTracer(World world) {
        this.world = world;
        this.blockStateCache = new Object2BooleanArrayMap();
    }

    public void clear() {
        this.blockStateCache.clear();
    }

    public <T extends ChunkGraphicsState> boolean isInDirectView(ChunkRenderContainer<T> render, float camX, float camY, float camZ) {
        List<BlockPos> srcTranslucent = render.getData().getTranslucentBlocks();
        int minX = MathHelper.func_76141_d((float)camX);
        int minY = MathHelper.func_76141_d((float)camY);
        int minZ = MathHelper.func_76141_d((float)camZ);
        ChunkRenderBounds bounds = render.getBounds();
        float boundMinX = bounds.x1;
        float boundMinY = bounds.y1;
        float boundMinZ = bounds.z1;
        float boundMaxX = bounds.x2;
        float boundMaxY = bounds.y2;
        float boundMaxZ = bounds.z2;
        for (BlockPos pos : srcTranslucent) {
            if (!this.checkIntersectingGrids(minX, minY, minZ, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), boundMinX, boundMinY, boundMinZ, boundMaxX, boundMaxY, boundMaxZ)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIntersectingGrids(int x, int y, int z, int maxX, int maxY, int maxZ, float boundMinX, float boundMinY, float boundMinZ, float boundMaxX, float boundMaxY, float boundMaxZ) {
        float dx = Math.abs(maxX - x);
        float dy = Math.abs(maxY - y);
        float dz = Math.abs(maxZ - z);
        float xWeight = 1.0f / dx;
        float yWeight = 1.0f / dy;
        float zWeight = 1.0f / dz;
        int x_inc = Integer.compare(maxX, x);
        int y_inc = Integer.compare(maxY, y);
        int z_inc = Integer.compare(maxZ, z);
        float errorX = xWeight;
        float errorY = yWeight;
        float errorZ = zWeight;
        for (float n = 1.0f + dx + dy + dz; n > 0.0f; n -= 1.0f) {
            if (((float)x >= boundMinX || (float)x <= boundMaxX) && ((float)y >= boundMinY || (float)x <= boundMaxY) && ((float)z >= boundMinZ || (float)x <= boundMaxZ)) {
                return true;
            }
            BlockPos curr = new BlockPos(x, y, z);
            if (this.blockStateCache.getOrDefault((Object)curr, false)) {
                return false;
            }
            BlockState state = this.world.func_180495_p(curr);
            if (!state.func_196958_f() && state.func_200015_d((IBlockReader)this.world, curr)) {
                this.blockStateCache.put((Object)curr, true);
                return false;
            }
            this.blockStateCache.put((Object)curr, false);
            if (errorX < errorY && errorX < errorZ) {
                x += x_inc;
                errorX += xWeight;
                continue;
            }
            if (errorY < errorX && errorY < errorZ) {
                y += y_inc;
                errorY += yWeight;
                continue;
            }
            z += z_inc;
            errorZ += zWeight;
        }
        return true;
    }
}

