/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;
import java.util.function.Function;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderFogComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.MemoryStack;

public class ChunkProgram
extends GlProgram {
    private final int uModelViewProjectionMatrix = this.getUniformLocation("u_ModelViewProjectionMatrix");
    private final int uModelScale;
    private final int uTextureScale;
    private final int uBlockTex = this.getUniformLocation("u_BlockTex");
    private final int uLightTex = this.getUniformLocation("u_LightTex");
    private final ChunkShaderFogComponent fogShader;

    protected ChunkProgram(RenderDevice owner, ResourceLocation name, int handle, Function<ChunkProgram, ChunkShaderFogComponent> fogShaderFunction) {
        super(owner, name, handle);
        this.uModelScale = this.getUniformLocation("u_ModelScale");
        this.uTextureScale = this.getUniformLocation("u_TextureScale");
        this.fogShader = fogShaderFunction.apply(this);
    }

    public void setup(MatrixStack matrixStack, float modelScale, float textureScale, Matrix4f projection) {
        GL20C.glUniform1i((int)this.uBlockTex, (int)0);
        GL20C.glUniform1i((int)this.uLightTex, (int)2);
        GL20C.glUniform3f((int)this.uModelScale, (float)modelScale, (float)modelScale, (float)modelScale);
        GL20C.glUniform2f((int)this.uTextureScale, (float)textureScale, (float)textureScale);
        this.fogShader.setup();
        MatrixStack.Entry matrices = matrixStack.func_227866_c_();
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer bufModelViewProjection = stack.mallocFloat(16);
            Matrix4f modelView = matrices.func_227870_a_().func_226601_d_();
            modelView.multiplyBackward(projection);
            modelView.func_195879_b(bufModelViewProjection);
            GL20.glUniformMatrix4fv((int)this.uModelViewProjectionMatrix, (boolean)false, (FloatBuffer)bufModelViewProjection);
        }
    }
}

