/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.tasks;

import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheLocal;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.common.util.RenderTypeLookupUtil;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.ForgeHooksClient;

public class ChunkRenderRebuildTask<T extends ChunkGraphicsState>
extends ChunkRenderBuildTask<T> {
    private static final int CHUNK_BUILD_SIZE = 16;
    private final ChunkRenderContainer<T> render;
    private final Vector3d camera;
    private final BlockPos offset;
    private final boolean translucencySorting;
    private final ChunkRenderContext context;

    public ChunkRenderRebuildTask(ChunkRenderContainer<T> render, ChunkRenderContext context, BlockPos offset, Vector3d camera) {
        this.render = render;
        this.offset = offset;
        this.camera = camera;
        this.translucencySorting = SodiumClientMod.options().advanced.translucencySorting;
        this.context = context;
    }

    @Override
    public ChunkBuildResult<T> performBuild(ChunkRenderCacheLocal cache, ChunkBuildBuffers buffers, CancellationSource cancellationSource) {
        ChunkRenderData.Builder renderData = new ChunkRenderData.Builder();
        VisGraph occluder = new VisGraph();
        ChunkRenderBounds.Builder bounds = new ChunkRenderBounds.Builder();
        buffers.init(renderData);
        cache.init(this.context);
        WorldSlice slice = cache.getWorldSlice();
        int baseX = this.render.getOriginX();
        int baseY = this.render.getOriginY();
        int baseZ = this.render.getOriginZ();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockPos renderOffset = this.offset;
        boolean shouldSortBackwards = false;
        for (int relY = 0; relY < 16; ++relY) {
            if (cancellationSource.isCancelled()) {
                return null;
            }
            for (int relZ = 0; relZ < 16; ++relZ) {
                for (int relX = 0; relX < 16; ++relX) {
                    BlockState state = slice.getBlockState(baseX + relX, baseY + relY, baseZ + relZ, null);
                    if (this.translucencySorting && !shouldSortBackwards) {
                        for (BlockRenderPass pass : BlockRenderPass.TRANSLUCENTS) {
                            if (!RenderTypeLookupUtil.canRenderInLayer(state, pass.getLayer())) continue;
                            shouldSortBackwards = true;
                            break;
                        }
                    }
                    this.setupBlockRender(cache, buffers, renderData, slice, occluder, bounds, pos, renderOffset, state, relX, relY, relZ, relX + baseX, relY + baseY, relZ + baseZ);
                }
            }
        }
        this.render.setRebuildableForTranslucents(shouldSortBackwards);
        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
            ChunkMeshData mesh = buffers.createMesh(pass, (float)this.camera.field_72450_a - (float)this.offset.func_177958_n(), (float)this.camera.field_72448_b - (float)this.offset.func_177956_o(), (float)this.camera.field_72449_c - (float)this.offset.func_177952_p(), shouldSortBackwards);
            if (mesh == null) continue;
            renderData.setMesh(pass, mesh);
        }
        renderData.setOcclusionData(occluder.func_178607_a());
        renderData.setBounds(bounds.build(this.render.getChunkPos()));
        return new ChunkBuildResult<T>(this.render, renderData.build());
    }

    private void setupBlockRender(ChunkRenderCacheLocal cache, ChunkBuildBuffers buffers, ChunkRenderData.Builder renderData, WorldSlice slice, VisGraph occluder, ChunkRenderBounds.Builder bounds, BlockPos.Mutable pos, BlockPos offset, BlockState blockState, int relX, int relY, int relZ, int x, int y, int z) {
        TileEntityRenderer renderer;
        TileEntity entity;
        if (blockState.func_196958_f()) {
            return;
        }
        pos.func_181079_c(x, y, z);
        buffers.setRenderOffset(x - offset.func_177958_n(), y - offset.func_177956_o(), z - offset.func_177952_p());
        if (blockState.func_200015_d((IBlockReader)slice, (BlockPos)pos)) {
            occluder.func_178606_a((BlockPos)pos);
        }
        if (blockState.hasTileEntity() && (entity = slice.func_175625_s((BlockPos)pos)) != null && (renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(entity)) != null) {
            renderData.addBlockEntity(entity, !renderer.func_188185_a(entity));
            bounds.addBlock(relX, relY, relZ);
        }
        for (RenderType layer : RenderType.func_228661_n_()) {
            ForgeHooksClient.setRenderLayer((RenderType)layer);
            FluidState fluidState = blockState.func_204520_s();
            if (!fluidState.func_206888_e() && RenderTypeLookupUtil.canRenderInLayer(fluidState, layer)) {
                if (layer == RenderType.func_228645_f_() || layer == RenderType.func_241715_r_()) {
                    renderData.addTranslucentBlock(pos.func_185334_h());
                }
                if (cache.getFluidRenderer().render(slice, fluidState, (BlockPos)pos, buffers.get(layer))) {
                    bounds.addBlock(relX, relY, relZ);
                }
            }
            if (blockState.func_185901_i() != BlockRenderType.MODEL || !RenderTypeLookupUtil.canRenderInLayer(blockState, layer)) continue;
            if (layer == RenderType.func_228645_f_() || layer == RenderType.func_241715_r_()) {
                renderData.addTranslucentBlock(pos.func_185334_h());
            }
            IBakedModel model = cache.getBlockModels().func_178125_b(blockState);
            long seed = blockState.func_209533_a((BlockPos)pos);
            if (!cache.getBlockRenderer().renderModel(slice, blockState, (BlockPos)pos, model, buffers.get(layer), true, seed)) continue;
            bounds.addBlock(relX, relY, relZ);
        }
        ForgeHooksClient.setRenderLayer(null);
    }

    @Override
    public void releaseResources() {
        this.context.releaseResources();
    }
}

