/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.common.util;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@NotThreadSafe
public class MetricsUtil {
    private static final Logger log = LogManager.getLogger(MetricsUtil.class);
    private static final Map<String, Triple<Float, Long, Long>> METRICS = new HashMap<String, Triple<Float, Long, Long>>();

    public static void startMetric(String name) {
        if (METRICS.containsKey(name)) {
            Triple<Float, Long, Long> t = METRICS.get(name);
            METRICS.put(name, (Triple<Float, Long, Long>)Triple.of((Object)t.getLeft(), (Object)t.getMiddle(), (Object)System.currentTimeMillis()));
        } else {
            METRICS.put(name, (Triple<Float, Long, Long>)Triple.of((Object)Float.valueOf(0.0f), (Object)0L, (Object)System.currentTimeMillis()));
        }
    }

    public static void endMetric(String name) {
        Triple<Float, Long, Long> t = METRICS.get(name);
        if (t == null) {
            throw new RuntimeException("Metrics needs to be started first!");
        }
        float f = ((Float)t.getLeft()).floatValue();
        long m = (Long)t.getMiddle();
        long l = (Long)t.getRight();
        if (l < 0L) {
            throw new RuntimeException("Metrics needs to be started first!");
        }
        f = (f * (float)m + (float)(System.currentTimeMillis() - l)) / (float)(m + 1L);
        METRICS.put(name, (Triple<Float, Long, Long>)Triple.of((Object)Float.valueOf(f), (Object)(m + 1L), (Object)-1L));
    }

    public static void logMetrics() {
        for (Map.Entry<String, Triple<Float, Long, Long>> entry : METRICS.entrySet()) {
            Triple<Float, Long, Long> t = entry.getValue();
            log.info("Metric {} latency={} ms, count={}", (Object)entry.getKey(), t.getLeft(), t.getMiddle());
        }
    }
}

