/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.common.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.FluidState;

public class RenderTypeLookupUtil {
    private static final Map<BlockStateKey, Boolean> blockStateLookup = new ConcurrentHashMap<BlockStateKey, Boolean>();
    private static final Map<FluidStateKey, Boolean> fluidStateLookup = new ConcurrentHashMap<FluidStateKey, Boolean>();

    public static synchronized boolean canRenderInLayer(BlockState state, RenderType layer) {
        BlockStateKey key = new BlockStateKey(state, layer);
        if (blockStateLookup.containsKey(key) && !(state.func_177230_c() instanceof LeavesBlock)) {
            return blockStateLookup.get(key);
        }
        boolean canRender = RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)layer);
        blockStateLookup.put(key, canRender);
        return canRender;
    }

    public static synchronized boolean canRenderInLayer(FluidState state, RenderType layer) {
        FluidStateKey key = new FluidStateKey(state, layer);
        if (fluidStateLookup.containsKey(key)) {
            return fluidStateLookup.get(key);
        }
        boolean canRender = RenderTypeLookup.canRenderInLayer((FluidState)state, (RenderType)layer);
        fluidStateLookup.put(key, canRender);
        return canRender;
    }

    private static class FluidStateKey {
        private final FluidState state;
        private final RenderType layer;

        public FluidStateKey(FluidState state, RenderType layer) {
            this.state = state;
            this.layer = layer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FluidStateKey)) {
                return false;
            }
            FluidStateKey other = (FluidStateKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RenderType this$layer = this.layer;
            RenderType other$layer = other.layer;
            if (this$layer == null ? other$layer != null : !this$layer.equals(other$layer)) {
                return false;
            }
            FluidState this$state = this.state;
            FluidState other$state = other.state;
            if (this$state == null && other$state != null || this$state != null && other$state == null) {
                return false;
            }
            if (this$state == other$state) {
                return true;
            }
            return this$state.func_206886_c().equals(other$state.func_206886_c());
        }

        protected boolean canEqual(Object other) {
            return other instanceof FluidStateKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FluidState $state = this.state;
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            RenderType $layer = this.layer;
            result = result * 59 + ($layer == null ? 43 : $layer.hashCode());
            return result;
        }
    }

    private static class BlockStateKey {
        private final BlockState state;
        private final RenderType layer;

        public BlockStateKey(BlockState state, RenderType layer) {
            this.state = state;
            this.layer = layer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlockStateKey)) {
                return false;
            }
            BlockStateKey other = (BlockStateKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RenderType this$layer = this.layer;
            RenderType other$layer = other.layer;
            if (this$layer == null ? other$layer != null : !this$layer.equals(other$layer)) {
                return false;
            }
            BlockState this$state = this.state;
            BlockState other$state = other.state;
            if (this$state == null && other$state != null || this$state != null && other$state == null) {
                return false;
            }
            if (this$state == other$state) {
                return true;
            }
            return this$state.func_177230_c().equals(other$state.func_177230_c());
        }

        protected boolean canEqual(Object other) {
            return other instanceof BlockStateKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BlockState $state = this.state;
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            RenderType $layer = this.layer;
            result = result * 59 + ($layer == null ? 43 : $layer.hashCode());
            return result;
        }
    }
}

