/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.ai.pathing;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Region;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Region.class})
public class ChunkCacheMixin {
    private static final BlockState DEFAULT_BLOCK = Blocks.field_150350_a.func_176223_P();
    @Shadow
    @Final
    protected IChunk[][] field_72817_c;
    @Shadow
    @Final
    protected int field_72818_a;
    @Shadow
    @Final
    protected int field_72816_b;
    private IChunk[] chunksFlat;
    private int xLen;
    private int zLen;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(World world, BlockPos minPos, BlockPos maxPos, CallbackInfo ci) {
        this.xLen = 1 + (maxPos.func_177958_n() >> 4) - (minPos.func_177958_n() >> 4);
        this.zLen = 1 + (maxPos.func_177952_p() >> 4) - (minPos.func_177952_p() >> 4);
        this.chunksFlat = new Chunk[this.xLen * this.zLen];
        for (int x = 0; x < this.xLen; ++x) {
            System.arraycopy(this.field_72817_c[x], 0, this.chunksFlat, x * this.zLen, this.zLen);
        }
    }

    @Overwrite
    public BlockState func_180495_p(BlockPos pos) {
        int y = pos.func_177956_o();
        if (!World.func_217405_b((int)pos.func_177956_o())) {
            ChunkSection section;
            IChunk chunk;
            int x = pos.func_177958_n();
            int z = pos.func_177952_p();
            int chunkX = (x >> 4) - this.field_72818_a;
            int chunkZ = (z >> 4) - this.field_72816_b;
            if (chunkX >= 0 && chunkX < this.xLen && chunkZ >= 0 && chunkZ < this.zLen && (chunk = this.chunksFlat[chunkX * this.zLen + chunkZ]) != null && (section = chunk.func_76587_i()[y >> 4]) != null) {
                return section.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
            }
        }
        return DEFAULT_BLOCK;
    }

    @Overwrite
    public FluidState func_204610_c(BlockPos pos) {
        return this.func_180495_p(pos).func_204520_s();
    }
}

