/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.ai.pathing;

import me.jellysquid.mods.lithium.common.ai.pathing.PathNodeCache;
import me.jellysquid.mods.lithium.common.world.WorldHelper;
import net.minecraft.block.BlockState;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={WalkNodeProcessor.class})
public abstract class LandPathNodeMakerMixin {
    @Overwrite
    public static PathNodeType func_237238_b_(IBlockReader blockView, BlockPos blockPos) {
        BlockState blockState = blockView.func_180495_p(blockPos);
        PathNodeType type = PathNodeCache.getPathNodeType(blockState);
        if (type == PathNodeType.OPEN) {
            if (!blockState.func_196957_g(blockView, blockPos, PathType.LAND)) {
                return PathNodeType.BLOCKED;
            }
            return PathNodeType.OPEN;
        }
        return type;
    }

    @Overwrite
    public static PathNodeType func_237232_a_(IBlockReader world, BlockPos.Mutable pos, PathNodeType type) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        ChunkSection section = null;
        if (world instanceof ICollisionReader && WorldHelper.areNeighborsWithinSameChunk((BlockPos)pos)) {
            IChunk chunk;
            if (!World.func_217405_b((int)y) && (chunk = (IChunk)((ICollisionReader)world).func_225522_c_(x >> 4, z >> 4)) != null) {
                section = chunk.func_76587_i()[y >> 4];
            }
            if (ChunkSection.func_222628_a(section) || PathNodeCache.isSectionSafeAsNeighbor(section)) {
                return type;
            }
        }
        for (int y2 = -1; y2 <= 1; ++y2) {
            for (int z2 = -1; z2 <= 1; ++z2) {
                for (int x2 = -1; x2 <= 1; ++x2) {
                    PathNodeType neighborType;
                    if (x2 == 0 && z2 == 0) continue;
                    pos.func_181079_c(x2 + x, y2 + y, z2 + z);
                    BlockState state = section != null ? section.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF) : world.func_180495_p((BlockPos)pos);
                    if (state.func_196958_f() || (neighborType = PathNodeCache.getNeighborPathNodeType(state)) == PathNodeType.OPEN) continue;
                    return neighborType;
                }
            }
        }
        return type;
    }
}

