/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.ai.poi;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.jellysquid.mods.lithium.common.world.interests.PointOfInterestDataExtended;
import me.jellysquid.mods.lithium.common.world.interests.PointOfInterestSetExtended;
import me.jellysquid.mods.lithium.common.world.interests.RegionBasedStorageSectionExtended;
import me.jellysquid.mods.lithium.common.world.interests.iterator.NearbyPointOfInterestStream;
import me.jellysquid.mods.lithium.common.world.interests.iterator.SinglePointOfInterestTypeFilter;
import me.jellysquid.mods.lithium.common.world.interests.types.PointOfInterestTypeHelper;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestData;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.storage.RegionSectionCache;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PointOfInterestManager.class})
public abstract class PointOfInterestStorageMixin
extends RegionSectionCache<PointOfInterestData>
implements PointOfInterestDataExtended {
    public PointOfInterestStorageMixin(File directory, Function<Runnable, Codec<PointOfInterestData>> function, Function<Runnable, PointOfInterestData> function2, DataFixer dataFixer, DefaultTypeReferences dataFixTypes, boolean bl) {
        super(directory, function, function2, dataFixer, dataFixTypes, bl);
    }

    @Overwrite
    public void func_219139_a(ChunkPos chunkPos_1, ChunkSection section) {
        SectionPos sectionPos = SectionPos.func_218156_a((ChunkPos)chunkPos_1, (int)(section.func_222632_g() >> 4));
        PointOfInterestData set = this.func_219113_d(sectionPos.func_218146_v()).orElse(null);
        if (set != null) {
            set.func_218240_a(consumer -> {
                if (PointOfInterestTypeHelper.shouldScan(section)) {
                    this.func_219132_a(section, sectionPos, (BiConsumer<BlockPos, PointOfInterestType>)consumer);
                }
            });
        } else if (PointOfInterestTypeHelper.shouldScan(section)) {
            set = (PointOfInterestData)this.func_235995_e_(sectionPos.func_218146_v());
            this.func_219132_a(section, sectionPos, (arg_0, arg_1) -> ((PointOfInterestData)set).func_218243_a(arg_0, arg_1));
        }
    }

    @Overwrite
    public Stream<PointOfInterest> func_219137_a(Predicate<PointOfInterestType> predicate, ChunkPos pos, PointOfInterestManager.Status status) {
        return ((RegionBasedStorageSectionExtended)((Object)this)).getWithinChunkColumn(pos.field_77276_a, pos.field_77275_b).flatMap(set -> set.func_218247_a(predicate, status));
    }

    @Overwrite
    public Optional<BlockPos> func_219163_a(Predicate<PointOfInterestType> typePredicate, Predicate<BlockPos> posPredicate, PointOfInterestManager.Status status, BlockPos pos, int radius, Random rand) {
        List<PointOfInterest> list = this.collectWithinRadius(typePredicate, pos, radius, status);
        Collections.shuffle(list, rand);
        for (PointOfInterest point : list) {
            if (!posPredicate.test(point.func_218261_f())) continue;
            return Optional.of(point.func_218261_f());
        }
        return Optional.empty();
    }

    @Overwrite
    public Optional<BlockPos> func_234148_d_(Predicate<PointOfInterestType> predicate, BlockPos pos, int radius, PointOfInterestManager.Status status) {
        List<PointOfInterest> points = this.collectWithinRadius(predicate, pos, radius, status);
        BlockPos nearest = null;
        double nearestDistance = Double.POSITIVE_INFINITY;
        for (PointOfInterest point : points) {
            double distance = point.func_218261_f().func_177951_i((Vector3i)pos);
            if (!(distance < nearestDistance)) continue;
            nearest = point.func_218261_f();
            nearestDistance = distance;
        }
        return Optional.ofNullable(nearest);
    }

    @Overwrite
    public long func_219145_a(Predicate<PointOfInterestType> predicate, BlockPos pos, int radius, PointOfInterestManager.Status status) {
        return this.collectWithinRadius(predicate, pos, radius, status).size();
    }

    @Overwrite
    public Stream<PointOfInterest> func_219146_b(Predicate<PointOfInterestType> predicate, BlockPos origin, int radius, PointOfInterestManager.Status status) {
        double radiusSq = radius * radius;
        return this.iterateSpiral(origin, radius, status, predicate, poi -> PointOfInterestStorageMixin.isWithinCircleRadius(poi.func_218261_f(), radiusSq, origin));
    }

    @Override
    public Optional<BlockPos> findNearestInSquare(BlockPos origin, int radius, PointOfInterestType type, PointOfInterestManager.Status status, Predicate<PointOfInterest> predicate) {
        return this.iterateSpiral(origin, radius, status, new SinglePointOfInterestTypeFilter(type), poi -> PointOfInterestStorageMixin.isWithinSquareRadius(origin, radius, poi.func_218261_f()) && predicate.test((PointOfInterest)poi)).map(PointOfInterest::func_218261_f).findFirst();
    }

    private List<PointOfInterest> collectWithinRadius(Predicate<PointOfInterestType> predicate, BlockPos origin, int radius, PointOfInterestManager.Status status) {
        double radiusSq = radius * radius;
        int minChunkX = origin.func_177958_n() - radius - 1 >> 4;
        int minChunkZ = origin.func_177952_p() - radius - 1 >> 4;
        int maxChunkX = origin.func_177958_n() + radius + 1 >> 4;
        int maxChunkZ = origin.func_177952_p() + radius + 1 >> 4;
        RegionBasedStorageSectionExtended storage = (RegionBasedStorageSectionExtended)((Object)this);
        ArrayList<PointOfInterest> points = new ArrayList<PointOfInterest>();
        Consumer<PointOfInterest> collector = point -> {
            if (PointOfInterestStorageMixin.isWithinCircleRadius(origin, radiusSq, point.func_218261_f())) {
                points.add((PointOfInterest)point);
            }
        };
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                for (PointOfInterestData set : storage.getInChunkColumn(x, z)) {
                    ((PointOfInterestSetExtended)set).collectMatchingPoints(predicate, status, collector);
                }
            }
        }
        return points;
    }

    private Stream<PointOfInterest> iterateSpiral(BlockPos origin, int radius, PointOfInterestManager.Status status, Predicate<PointOfInterestType> typePredicate, Predicate<PointOfInterest> pointPredicate) {
        RegionBasedStorageSectionExtended storage = (RegionBasedStorageSectionExtended)((Object)this);
        return StreamSupport.stream(new NearbyPointOfInterestStream(typePredicate, status, pointPredicate, origin, radius, storage), false);
    }

    private static boolean isWithinSquareRadius(BlockPos origin, int radius, BlockPos pos) {
        return Math.abs(pos.func_177958_n() - origin.func_177958_n()) <= radius && Math.abs(pos.func_177952_p() - origin.func_177952_p()) <= radius;
    }

    private static boolean isWithinCircleRadius(BlockPos origin, double radiusSq, BlockPos pos) {
        return origin.func_177951_i((Vector3i)pos) <= radiusSq;
    }

    @Shadow
    protected abstract void func_219132_a(ChunkSection var1, SectionPos var2, BiConsumer<BlockPos, PointOfInterestType> var3);
}

