/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.chunk.count_oversized_blocks;

import me.jellysquid.mods.lithium.common.entity.movement.ChunkAwareBlockCollisionSweeper;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.palette.PalettedContainer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ChunkSection.class})
public abstract class ChunkSectionMixin
implements ChunkAwareBlockCollisionSweeper.OversizedBlocksCounter {
    @Unique
    private short oversizedBlockCount;

    @Shadow
    public abstract void func_76672_e();

    @Redirect(method={"recalculateRefCounts"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/palette/PalettedContainer;count(Lnet/minecraft/util/palette/PalettedContainer$ICountConsumer;)V"))
    private void addToOversizedBlockCount(PalettedContainer<BlockState> palettedContainer, PalettedContainer.ICountConsumer<BlockState> consumer) {
        palettedContainer.func_225497_a((state, count) -> {
            consumer.accept(state, count);
            if (state.func_215704_f()) {
                this.oversizedBlockCount = (short)(this.oversizedBlockCount + count);
            }
        });
    }

    @Inject(method={"recalculateRefCounts"}, at={@At(value="HEAD")})
    private void resetOversizedBlockCount(CallbackInfo ci) {
        this.oversizedBlockCount = 0;
    }

    @Inject(method={"setBlockState(IIILnet/minecraft/block/BlockState;Z)Lnet/minecraft/block/BlockState;"}, at={@At(ordinal=0, value="INVOKE", target="Lnet/minecraft/block/BlockState;ticksRandomly()Z", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void decrOversizedBlockCount(int x, int y, int z, BlockState state, boolean lock, CallbackInfoReturnable<BlockState> cir, BlockState blockState2, FluidState fluidState, FluidState fluidState2) {
        if (blockState2.func_215704_f()) {
            this.oversizedBlockCount = (short)(this.oversizedBlockCount - 1);
        }
    }

    @Inject(method={"setBlockState(IIILnet/minecraft/block/BlockState;Z)Lnet/minecraft/block/BlockState;"}, at={@At(ordinal=1, value="INVOKE", target="Lnet/minecraft/block/BlockState;ticksRandomly()Z", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void incrOversizedBlockCount(int x, int y, int z, BlockState state, boolean lock, CallbackInfoReturnable<BlockState> cir) {
        if (state.func_215704_f()) {
            this.oversizedBlockCount = (short)(this.oversizedBlockCount + 1);
        }
    }

    @Override
    public boolean hasOversizedBlocks() {
        return this.oversizedBlockCount > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"read"}, at={@At(value="RETURN")})
    private void initCounts(PacketBuffer packetByteBuf, CallbackInfo ci) {
        this.func_76672_e();
    }
}

