/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.chunk.light;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import me.jellysquid.mods.phosphor.common.chunk.light.IReadonly;
import me.jellysquid.mods.phosphor.common.chunk.light.LevelPropagatorAccess;
import me.jellysquid.mods.phosphor.common.chunk.light.SkyLightStorageDataAccess;
import me.jellysquid.mods.phosphor.common.util.chunk.light.EmptyChunkNibbleArray;
import me.jellysquid.mods.phosphor.common.util.chunk.light.SkyLightChunkNibbleArray;
import me.jellysquid.mods.phosphor.common.util.math.ChunkSectionPosHelper;
import me.jellysquid.mods.sodium.mixin.chunk.light.MixinLightStorage;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.lighting.SkyLightStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SkyLightStorage.class})
public abstract class MixinSkyLightStorage
extends MixinLightStorage<SkyLightStorage.StorageMap> {
    @Unique
    private final LongSet preInitSkylightChunks = new LongOpenHashSet();
    @Unique
    private final LongSet initSkylightChunks = new LongOpenHashSet();
    @Shadow
    @Final
    private LongSet field_215558_o;
    @Shadow
    private volatile boolean field_215553_p;
    @Unique
    private static final NibbleArray DIRECT_SKYLIGHT_MAP = MixinSkyLightStorage.createDirectSkyLightMap();
    @Unique
    private final Long2IntMap vanillaLightmapComplexities = new Long2IntOpenHashMap();
    @Unique
    private final LongSet removedLightmaps = new LongOpenHashSet();

    /*
     * Unable to fully structure code
     */
    @Overwrite
    public int func_215525_d(long pos) {
        posX = BlockPos.func_218290_b((long)pos);
        posYOrig = BlockPos.func_218274_c((long)pos);
        posZ = BlockPos.func_218282_d((long)pos);
        chunkX = SectionPos.func_218159_a((int)posX);
        chunkYOrig = SectionPos.func_218159_a((int)posYOrig);
        chunkZ = SectionPos.func_218159_a((int)posZ);
        chunkOrig = SectionPos.func_218166_b((int)chunkX, (int)chunkYOrig, (int)chunkZ);
        lock = this.getStorageLock();
        do lbl-1000:
        // 4 sources

        {
            block2: {
                stamp = lock.tryOptimisticRead();
                posY = posYOrig;
                chunkY = chunkYOrig;
                chunk = chunkOrig;
                data = (SkyLightStorage.StorageMap)this.getStorage();
                sdata = (SkyLightStorageDataAccess)data;
                height = sdata.getHeight(SectionPos.func_218169_f((long)chunk));
                if (height != sdata.getDefaultHeight() && chunkY < height) break block2;
                if (!lock.validate(stamp)) ** GOTO lbl-1000
                return 15;
            }
            array = data.func_215638_c(chunk);
            while (array == null) {
                block3: {
                    if (++chunkY < height) break block3;
                    if (!lock.validate(stamp)) ** GOTO lbl-1000
                    return 15;
                }
                chunk = ChunkSectionPosHelper.updateYLong(chunk, chunkY);
                array = data.func_215638_c(chunk);
                posY = chunkY << 4;
            }
        } while (!lock.validate(stamp));
        return array.func_76582_a(SectionPos.func_218171_b((int)posX), SectionPos.func_218171_b((int)posY), SectionPos.func_218171_b((int)posZ));
    }

    @Shadow
    protected abstract boolean func_215549_m(long var1);

    @Shadow
    protected abstract boolean func_215548_n(long var1);

    @Override
    public int getLightWithoutLightmap(long blockPos) {
        long sectionPos = SectionPos.func_218162_e((long)blockPos);
        NibbleArray lightmap = this.getLightmapAbove(sectionPos);
        if (lightmap == null) {
            return this.func_215548_n(sectionPos) ? 15 : 0;
        }
        return lightmap.func_76582_a(SectionPos.func_218171_b((int)BlockPos.func_218290_b((long)blockPos)), 0, SectionPos.func_218171_b((int)BlockPos.func_218282_d((long)blockPos)));
    }

    @Redirect(method={"getOrCreateArray(J)Lnet/minecraft/world/chunk/NibbleArray;"}, at=@At(value="NEW", target="net/minecraft/world/chunk/NibbleArray"))
    private NibbleArray initializeLightmap(long pos) {
        NibbleArray ret = new NibbleArray();
        if (this.func_215548_n(pos)) {
            Arrays.fill(ret.func_177481_a(), (byte)-1);
        }
        return ret;
    }

    @Inject(method={"scheduleSurfaceUpdate(J)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void disable_enqueueRemoveSection(CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"scheduleFullUpdate(J)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void disable_enqueueAddSection(CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public void beforeChunkEnabled(long chunkPos) {
        if (!this.func_215548_n(chunkPos)) {
            this.preInitSkylightChunks.add(chunkPos);
            this.func_215469_a(Long.MAX_VALUE, SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)16, (int)SectionPos.func_218153_d((long)chunkPos)), 1, true);
        }
    }

    @Override
    public void afterChunkDisabled(long chunkPos) {
        if (this.preInitSkylightChunks.remove(chunkPos)) {
            this.func_215469_a(Long.MAX_VALUE, SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)16, (int)SectionPos.func_218153_d((long)chunkPos)), 2, false);
        }
    }

    @Override
    protected int func_215516_b(long id) {
        int ret = super.func_215516_b(id);
        if (ret >= 2 && SectionPos.func_218144_c((long)id) == 16 && this.preInitSkylightChunks.contains(SectionPos.func_218169_f((long)id))) {
            return 1;
        }
        return ret;
    }

    @Override
    @Overwrite
    public void func_215526_b(long chunkPos, boolean enabled) {
        if (enabled) {
            if (this.preInitSkylightChunks.contains(chunkPos)) {
                this.initSkylightChunks.add(chunkPos);
                this.func_215552_e();
            } else {
                this.field_215558_o.add(chunkPos);
            }
        } else {
            this.field_215558_o.remove(chunkPos);
            this.initSkylightChunks.remove(chunkPos);
            this.func_215552_e();
        }
    }

    @Unique
    private static void spreadSourceSkylight(LevelPropagatorAccess lightProvider, long src, Direction dir) {
        lightProvider.invokePropagateLevel(src, BlockPos.func_218289_a((long)src, (Direction)dir), 0, true);
    }

    @Override
    @Overwrite
    public void func_215522_a(LightEngine<SkyLightStorage.StorageMap, ?> lightProvider, boolean doSkylight, boolean skipEdgeLightPropagation) {
        super.func_215522_a(lightProvider, doSkylight, skipEdgeLightPropagation);
        if (!doSkylight || !this.field_215553_p) {
            return;
        }
        LongIterator it = this.initSkylightChunks.iterator();
        while (it.hasNext()) {
            long chunkPos = it.nextLong();
            LevelPropagatorAccess levelPropagator = (LevelPropagatorAccess)lightProvider;
            int minY = this.fillSkylightColumn(lightProvider, chunkPos);
            this.field_215558_o.add(chunkPos);
            this.preInitSkylightChunks.remove(chunkPos);
            this.func_215469_a(Long.MAX_VALUE, SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)16, (int)SectionPos.func_218153_d((long)chunkPos)), 2, false);
            if (this.func_215518_g(SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)minY, (int)SectionPos.func_218153_d((long)chunkPos)))) {
                long blockPos = BlockPos.func_218276_a((int)SectionPos.func_218142_c((int)SectionPos.func_218173_b((long)chunkPos)), (int)SectionPos.func_218142_c((int)minY), (int)SectionPos.func_218142_c((int)SectionPos.func_218153_d((long)chunkPos)));
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        MixinSkyLightStorage.spreadSourceSkylight(levelPropagator, BlockPos.func_218291_a((long)blockPos, (int)x, (int)16, (int)z), Direction.DOWN);
                    }
                }
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                boolean spread = !this.initSkylightChunks.contains(SectionPos.func_218172_a((long)chunkPos, (Direction)dir));
                for (int y = 16; y > minY; --y) {
                    long sectionPos = SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)y, (int)SectionPos.func_218153_d((long)chunkPos));
                    long neighborSectionPos = SectionPos.func_218172_a((long)sectionPos, (Direction)dir);
                    if (!this.func_215518_g(neighborSectionPos)) continue;
                    if (!spread) {
                        if (!this.field_215535_b.contains(neighborSectionPos)) continue;
                        spread = true;
                    }
                    long blockPos = BlockPos.func_218276_a((int)SectionPos.func_218142_c((int)SectionPos.func_218173_b((long)sectionPos)), (int)SectionPos.func_218142_c((int)y), (int)SectionPos.func_218142_c((int)SectionPos.func_218153_d((long)sectionPos)));
                    int ox = 15 * Math.max(dir.func_82601_c(), 0);
                    int oz = 15 * Math.max(dir.func_82599_e(), 0);
                    int dx = Math.abs(dir.func_82599_e());
                    int dz = Math.abs(dir.func_82601_c());
                    for (int t = 0; t < 16; ++t) {
                        for (int dy = 0; dy < 16; ++dy) {
                            MixinSkyLightStorage.spreadSourceSkylight(levelPropagator, BlockPos.func_218291_a((long)blockPos, (int)(ox + t * dx), (int)dy, (int)(oz + t * dz)), dir);
                        }
                    }
                }
            }
        }
        this.initSkylightChunks.clear();
        if (!this.removedLightmaps.isEmpty()) {
            LongOpenHashSet removedLightmaps = new LongOpenHashSet((LongCollection)this.removedLightmaps);
            LongIterator it2 = removedLightmaps.iterator();
            while (it2.hasNext()) {
                long sectionPos = it2.nextLong();
                if (!this.enabledChunks.contains(SectionPos.func_218169_f((long)sectionPos)) || !this.removedLightmaps.contains(sectionPos)) continue;
                long sectionPosAbove = this.getSectionAbove(sectionPos);
                if (sectionPosAbove == Long.MAX_VALUE) {
                    this.updateVanillaLightmapsBelow(sectionPos, (NibbleArray)(this.func_215548_n(sectionPos) ? DIRECT_SKYLIGHT_MAP : null), true);
                    continue;
                }
                long removedLightmapPosAbove = sectionPos;
                long pos = sectionPos;
                while (pos != sectionPosAbove) {
                    if (this.removedLightmaps.remove(pos)) {
                        removedLightmapPosAbove = pos;
                    }
                    pos = SectionPos.func_218172_a((long)pos, (Direction)Direction.UP);
                }
                this.updateVanillaLightmapsBelow(removedLightmapPosAbove, this.vanillaLightmapComplexities.get(sectionPosAbove) == 0 ? null : this.func_215520_a(sectionPosAbove, true), false);
            }
            this.removedLightmaps.clear();
        }
        this.field_215553_p = false;
    }

    private int fillSkylightColumn(LightEngine<SkyLightStorage.StorageMap, ?> lightProvider, long chunkPos) {
        int y;
        long sectionPos;
        int minY = 16;
        NibbleArray lightmapAbove = null;
        while (this.func_215550_a(minY) && !this.field_215535_b.contains(sectionPos = SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)minY, (int)SectionPos.func_218153_d((long)chunkPos)))) {
            NibbleArray lightmap;
            if (this.func_215518_g(sectionPos)) {
                this.func_215528_a(lightProvider, sectionPos);
            }
            if ((lightmap = this.getLightmap(sectionPos)) != null) {
                lightmapAbove = lightmap;
            }
            --minY;
        }
        long sectionPosBelow = SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)minY, (int)SectionPos.func_218153_d((long)chunkPos));
        if (this.func_215518_g(sectionPosBelow)) {
            int x;
            int z;
            NibbleArray lightmapBelow = this.getLightmap(sectionPosBelow);
            if (lightmapBelow == null) {
                int complexity = 3840;
                if (lightmapAbove != null) {
                    for (z = 0; z < 16; ++z) {
                        for (x = 0; x < 16; ++x) {
                            complexity -= lightmapAbove.func_76582_a(x, 0, z);
                        }
                    }
                }
                this.getOrAddLightmap(sectionPosBelow);
                this.setLightmapComplexity(sectionPosBelow, complexity);
            } else {
                int amount = 0;
                for (z = 0; z < 16; ++z) {
                    for (x = 0; x < 16; ++x) {
                        amount += MixinSkyLightStorage.getComplexityChange(lightmapBelow.func_76582_a(x, 15, z), lightmapAbove == null ? 0 : lightmapAbove.func_76582_a(x, 0, z), 15);
                    }
                }
                this.changeLightmapComplexity(sectionPosBelow, amount);
            }
        }
        int sections = 0;
        for (y = 16; y > minY; --y) {
            long sectionPos2 = SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)y, (int)SectionPos.func_218153_d((long)chunkPos));
            if (!this.removeLightmap(sectionPos2)) continue;
            sections |= 1 << y + 1;
        }
        ((SkyLightStorage.StorageMap)this.field_215539_f).func_215643_c();
        for (y = 16; y > minY; --y) {
            if ((sections & 1 << y + 1) == 0) continue;
            this.func_215523_k(SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)y, (int)SectionPos.func_218153_d((long)chunkPos)));
        }
        for (y = 16; y > minY; --y) {
            long sectionPos3 = SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)y, (int)SectionPos.func_218153_d((long)chunkPos));
            if (!this.nonOptimizableSections.contains(sectionPos3)) continue;
            ((SkyLightStorage.StorageMap)this.field_215539_f).func_215640_a(sectionPos3, this.createTrivialVanillaLightmap(DIRECT_SKYLIGHT_MAP));
            this.field_215540_g.add(sectionPos3);
        }
        ((SkyLightStorage.StorageMap)this.field_215539_f).func_215643_c();
        return minY;
    }

    @Overwrite
    private void func_215552_e() {
        this.field_215553_p = !this.initSkylightChunks.isEmpty();
    }

    @Unique
    private static NibbleArray createDirectSkyLightMap() {
        NibbleArray lightmap = new NibbleArray();
        Arrays.fill(lightmap.func_177481_a(), (byte)-1);
        return lightmap;
    }

    @Override
    public boolean func_215518_g(long sectionPos) {
        return super.func_215518_g(sectionPos) && this.func_215520_a(sectionPos, true) != null;
    }

    @Redirect(method={"getOrCreateArray(J)Lnet/minecraft/world/chunk/NibbleArray;"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/lighting/SkyLightStorage;newArrays:Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", opcode=180)), at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;get(J)Ljava/lang/Object;", ordinal=0, remap=false))
    private Object cancelLightmapLookupFromQueue(Long2ObjectMap<NibbleArray> lightmapArray, long pos) {
        return null;
    }

    @Unique
    private static int getComplexityChange(int val, int oldNeighborVal, int newNeighborVal) {
        return Math.abs(newNeighborVal - val) - Math.abs(oldNeighborVal - val);
    }

    @Override
    protected void beforeLightChange(long blockPos, int oldVal, int newVal, NibbleArray lightmap) {
        long sectionPos = SectionPos.func_218162_e((long)blockPos);
        if (SectionPos.func_218171_b((int)BlockPos.func_218274_c((long)blockPos)) == 0) {
            this.vanillaLightmapComplexities.put(sectionPos, this.vanillaLightmapComplexities.get(sectionPos) + newVal - oldVal);
            long sectionPosBelow = this.getSectionBelow(sectionPos);
            if (sectionPosBelow != Long.MAX_VALUE) {
                NibbleArray lightmapBelow = this.getOrAddLightmap(sectionPosBelow);
                int x = SectionPos.func_218171_b((int)BlockPos.func_218290_b((long)blockPos));
                int z = SectionPos.func_218171_b((int)BlockPos.func_218282_d((long)blockPos));
                this.changeLightmapComplexity(sectionPosBelow, MixinSkyLightStorage.getComplexityChange(lightmapBelow.func_76582_a(x, 15, z), oldVal, newVal));
            }
        }
        if (this.field_215540_g.add(sectionPos)) {
            ((SkyLightStorage.StorageMap)this.field_215539_f).func_215641_a(sectionPos);
            this.updateVanillaLightmapsBelow(sectionPos, this.func_215520_a(sectionPos, true), false);
        }
    }

    @Shadow
    protected abstract boolean func_215550_a(int var1);

    @Unique
    private long getSectionBelow(long sectionPos) {
        int y = SectionPos.func_218144_c((long)sectionPos);
        while (this.func_215550_a(y)) {
            if (this.func_215518_g(sectionPos = SectionPos.func_218172_a((long)sectionPos, (Direction)Direction.DOWN))) {
                return sectionPos;
            }
            --y;
        }
        return Long.MAX_VALUE;
    }

    @Override
    protected int getLightmapComplexityChange(long blockPos, int oldVal, int newVal, NibbleArray lightmap) {
        NibbleArray lightmapAbove;
        long sectionPos = SectionPos.func_218162_e((long)blockPos);
        int x = SectionPos.func_218171_b((int)BlockPos.func_218290_b((long)blockPos));
        int y = SectionPos.func_218171_b((int)BlockPos.func_218274_c((long)blockPos));
        int z = SectionPos.func_218171_b((int)BlockPos.func_218282_d((long)blockPos));
        int valAbove = y < 15 ? lightmap.func_76582_a(x, y + 1, z) : ((lightmapAbove = this.getLightmapAbove(sectionPos)) == null ? this.getDirectSkylight(sectionPos) : lightmapAbove.func_76582_a(x, 0, z));
        int amount = MixinSkyLightStorage.getComplexityChange(valAbove, oldVal, newVal);
        if (y > 0) {
            amount += MixinSkyLightStorage.getComplexityChange(lightmap.func_76582_a(x, y - 1, z), oldVal, newVal);
        }
        return amount;
    }

    @Unique
    private NibbleArray getLightmapAbove(long sectionPos) {
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        return sectionPosAbove == Long.MAX_VALUE ? null : this.func_215520_a(sectionPosAbove, true);
    }

    @Unique
    private long getSectionAbove(long sectionPos) {
        if (this.func_215549_m(sectionPos = SectionPos.func_218172_a((long)sectionPos, (Direction)Direction.UP))) {
            return Long.MAX_VALUE;
        }
        while (!this.hasLightmap(sectionPos)) {
            sectionPos = SectionPos.func_218172_a((long)sectionPos, (Direction)Direction.UP);
        }
        return sectionPos;
    }

    @Unique
    private int getDirectSkylight(long sectionPos) {
        return this.func_215548_n(sectionPos) ? 15 : 0;
    }

    @Override
    protected void beforeLightmapChange(long sectionPos, NibbleArray oldLightmap, NibbleArray newLightmap) {
        long sectionPosBelow = this.getSectionBelow(sectionPos);
        if (sectionPosBelow != Long.MAX_VALUE) {
            NibbleArray lightmapBelow = this.func_215520_a(sectionPosBelow, true);
            NibbleArray lightmapAbove = oldLightmap == null ? this.getLightmapAbove(sectionPos) : oldLightmap;
            int skyLight = this.getDirectSkylight(sectionPos);
            if (lightmapBelow == null) {
                int complexity = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        complexity += Math.abs(newLightmap.func_76582_a(x, 0, z) - (lightmapAbove == null ? skyLight : lightmapAbove.func_76582_a(x, 0, z)));
                    }
                }
                if (complexity != 0) {
                    this.getOrAddLightmap(sectionPosBelow);
                    this.setLightmapComplexity(sectionPosBelow, complexity);
                }
            } else {
                int amount = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        amount += MixinSkyLightStorage.getComplexityChange(lightmapBelow.func_76582_a(x, 15, z), lightmapAbove == null ? skyLight : lightmapAbove.func_76582_a(x, 0, z), newLightmap.func_76582_a(x, 0, z));
                    }
                }
                this.changeLightmapComplexity(sectionPosBelow, amount);
            }
        }
        this.updateVanillaLightmapsOnLightmapCreation(sectionPos, newLightmap);
    }

    @Override
    protected int getInitialLightmapComplexity(long sectionPos, NibbleArray lightmap) {
        int complexity = 0;
        for (int y = 0; y < 15; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    complexity += Math.abs(lightmap.func_76582_a(x, y + 1, z) - lightmap.func_76582_a(x, y, z));
                }
            }
        }
        NibbleArray lightmapAbove = this.getLightmapAbove(sectionPos);
        int skyLight = this.getDirectSkylight(sectionPos);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                complexity += Math.abs((lightmapAbove == null ? skyLight : lightmapAbove.func_76582_a(x, 0, z)) - lightmap.func_76582_a(x, 15, z));
            }
        }
        return complexity;
    }

    @Redirect(method={"removeSection(J)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/lighting/SkyLightStorage;hasSection(J)Z"))
    private boolean hasActualLightmap(SkyLightStorage lightStorage, long sectionPos) {
        return this.hasLightmap(sectionPos);
    }

    @Override
    public void func_215476_a(long id, int level) {
        int oldLevel = this.func_215471_c(id);
        if (oldLevel >= 2 && level < 2) {
            ((SkyLightStorageDataAccess)this.field_215539_f).updateMinHeight(SectionPos.func_218144_c((long)id));
        }
        super.func_215476_a(id, level);
    }

    @Override
    protected NibbleArray createInitialVanillaLightmap(long sectionPos) {
        if (!this.field_215535_b.contains(sectionPos) && !this.field_215535_b.contains(SectionPos.func_218172_a((long)sectionPos, (Direction)Direction.UP))) {
            return this.createTrivialVanillaLightmap(sectionPos);
        }
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        int complexity = sectionPosAbove == Long.MAX_VALUE ? (this.func_215548_n(sectionPos) ? 3840 : 0) : this.vanillaLightmapComplexities.get(sectionPosAbove);
        if (complexity == 0) {
            return this.createTrivialVanillaLightmap(null);
        }
        NibbleArray lightmap = new NibbleArray(new byte[2048]);
        ((SkyLightStorage.StorageMap)this.field_215539_f).func_215640_a(sectionPos, lightmap);
        ((SkyLightStorage.StorageMap)this.field_215539_f).func_215643_c();
        this.func_215524_j(sectionPos);
        this.setLightmapComplexity(sectionPos, complexity);
        return lightmap;
    }

    @Override
    protected NibbleArray createTrivialVanillaLightmap(long sectionPos) {
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        if (sectionPosAbove == Long.MAX_VALUE) {
            return this.createTrivialVanillaLightmap((NibbleArray)(this.func_215548_n(sectionPos) ? DIRECT_SKYLIGHT_MAP : null));
        }
        return this.createTrivialVanillaLightmap(this.vanillaLightmapComplexities.get(sectionPosAbove) == 0 ? null : this.func_215520_a(sectionPosAbove, true));
    }

    @Unique
    private NibbleArray createTrivialVanillaLightmap(NibbleArray lightmapAbove) {
        return lightmapAbove == null ? new EmptyChunkNibbleArray() : new SkyLightChunkNibbleArray(lightmapAbove);
    }

    @Inject(method={"addSection(J)V"}, at={@At(value="HEAD")})
    private void updateVanillaLightmapsOnLightmapCreation(long sectionPos, CallbackInfo ci) {
        this.updateVanillaLightmapsOnLightmapCreation(sectionPos, this.func_215520_a(sectionPos, true));
    }

    @Unique
    private void updateVanillaLightmapsOnLightmapCreation(long sectionPos, NibbleArray lightmap) {
        int complexity = 0;
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                complexity += lightmap.func_76582_a(x, 0, z);
            }
        }
        this.vanillaLightmapComplexities.put(sectionPos, complexity);
        this.removedLightmaps.remove(sectionPos);
        if (!this.enabledChunks.contains(SectionPos.func_218169_f((long)sectionPos))) {
            return;
        }
        this.updateVanillaLightmapsBelow(sectionPos, complexity == 0 ? null : lightmap, false);
    }

    @Inject(method={"removeSection(J)V"}, at={@At(value="HEAD")})
    private void updateVanillaLightmapsOnLightmapRemoval(long sectionPos, CallbackInfo ci) {
        this.vanillaLightmapComplexities.remove(sectionPos);
        if (!this.enabledChunks.contains(SectionPos.func_218169_f((long)sectionPos))) {
            return;
        }
        this.removedLightmaps.add(sectionPos);
    }

    @Unique
    private void updateVanillaLightmapsBelow(long sectionPos, NibbleArray lightmapAbove, boolean stopOnRemovedLightmap) {
        int y = SectionPos.func_218144_c((long)sectionPos) - 1;
        while (this.func_215550_a(y)) {
            NibbleArray lightmapBelow;
            long sectionPosBelow = SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)sectionPos), (int)y, (int)SectionPos.func_218153_d((long)sectionPos));
            if (stopOnRemovedLightmap) {
                if (this.removedLightmaps.contains(sectionPosBelow)) {
                    break;
                }
            } else {
                this.removedLightmaps.remove(sectionPosBelow);
            }
            if ((lightmapBelow = this.func_215520_a(sectionPosBelow, true)) != null) {
                if (!((IReadonly)lightmapBelow).isReadonly()) break;
                ((SkyLightStorage.StorageMap)this.field_215539_f).func_215640_a(sectionPosBelow, this.createTrivialVanillaLightmap(lightmapAbove));
                this.field_215540_g.add(sectionPosBelow);
            }
            --y;
        }
        ((SkyLightStorage.StorageMap)this.field_215539_f).func_215643_c();
    }
}

