/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.chunk.serialization;

import java.util.function.Function;
import me.jellysquid.mods.lithium.common.world.chunk.CompactingPackedIntegerArray;
import me.jellysquid.mods.lithium.common.world.chunk.LithiumHashPalette;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.BitArray;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.palette.PalettedContainer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PalettedContainer.class})
public abstract class PalettedContainerMixin<T> {
    private static final ThreadLocal<short[]> cachedCompactionArrays = ThreadLocal.withInitial(() -> new short[4096]);
    private static final long[] EMPTY_PALETTE_DATA = new long[256];
    @Shadow
    @Final
    private T field_205526_g;
    @Shadow
    @Final
    private ObjectIntIdentityMap<T> field_205523_d;
    @Shadow
    private int field_186024_e;
    @Shadow
    @Final
    private Function<CompoundNBT, T> field_205524_e;
    @Shadow
    @Final
    private Function<T, CompoundNBT> field_205525_f;
    @Shadow
    protected BitArray field_186021_b;
    @Shadow
    private IPalette<T> field_186022_c;

    @Shadow
    public abstract void func_210459_b();

    @Shadow
    public abstract void func_210460_c();

    @Shadow
    protected abstract T func_186015_a(int var1);

    @Overwrite
    public void func_196963_b(CompoundNBT rootTag, String paletteKey, String dataKey) {
        this.func_210459_b();
        LithiumHashPalette<T> palette = null;
        long[] dataArray = null;
        if (this.field_186022_c instanceof LithiumHashPalette && (palette = (LithiumHashPalette<T>)this.field_186022_c).getSize() == 1 && palette.func_186039_a(0) == this.field_205526_g) {
            dataArray = EMPTY_PALETTE_DATA;
        }
        if (dataArray == null) {
            LithiumHashPalette<T> compactedPalette = new LithiumHashPalette<T>(this.field_205523_d, this.field_186024_e, null, this.field_205524_e, this.field_205525_f);
            short[] array = cachedCompactionArrays.get();
            ((CompactingPackedIntegerArray)this.field_186021_b).compact(this.field_186022_c, compactedPalette, array);
            if (palette != null && palette.getSize() == compactedPalette.getSize()) {
                dataArray = (long[])this.field_186021_b.func_188143_a().clone();
            } else {
                int size = Math.max(4, MathHelper.func_151241_e((int)compactedPalette.getSize()));
                BitArray copy = new BitArray(size, 4096);
                for (int i = 0; i < array.length; ++i) {
                    copy.func_188141_a(i, (int)array[i]);
                }
                dataArray = copy.func_188143_a();
                palette = compactedPalette;
            }
        }
        ListNBT paletteTag = new ListNBT();
        palette.toTag(paletteTag);
        rootTag.func_218657_a(paletteKey, (INBT)paletteTag);
        rootTag.func_197644_a(dataKey, dataArray);
        this.func_210460_c();
    }

    @Inject(method={"count"}, at={@At(value="HEAD")}, cancellable=true)
    public void count(PalettedContainer.ICountConsumer<T> consumer, CallbackInfo ci) {
        int len = 1 << this.field_186024_e;
        if (len > 4096) {
            return;
        }
        short[] counts = new short[len];
        this.field_186021_b.func_225421_a(i -> {
            int n = i;
            counts[n] = (short)(counts[n] + 1);
        });
        for (int i2 = 0; i2 < counts.length; ++i2) {
            Object obj = this.field_186022_c.func_186039_a(i2);
            if (obj == null) continue;
            consumer.accept(obj, (int)counts[i2]);
        }
        ci.cancel();
    }
}

