/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.buffer_builder.fast_sort;

import com.google.common.primitives.Floats;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.BitSet;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.VertexFormat;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BufferBuilder.class})
public class MixinBufferBuilder {
    @Shadow
    private ByteBuffer field_179001_a;
    @Shadow
    private int field_178997_d;
    @Shadow
    private VertexFormat field_179011_q;
    @Shadow
    private int field_227823_k_;

    @Overwrite
    public void func_181674_a(float cameraX, float cameraY, float cameraZ) {
        ((Buffer)this.field_179001_a).clear();
        FloatBuffer floatBuffer = this.field_179001_a.asFloatBuffer();
        int vertexStride = this.field_179011_q.func_177338_f();
        int quadStride = this.field_179011_q.func_181719_f() * 4;
        int quadStart = this.field_227823_k_ / 4;
        int quadCount = this.field_178997_d / 4;
        int vertexSizeInteger = this.field_179011_q.func_181719_f();
        float[] distanceArray = new float[quadCount];
        int[] indicesArray = new int[quadCount];
        for (int quadIdx = 0; quadIdx < quadCount; ++quadIdx) {
            distanceArray[quadIdx] = MixinBufferBuilder.getDistanceSq(floatBuffer, cameraX, cameraY, cameraZ, vertexSizeInteger, quadStart + quadIdx * vertexStride);
            indicesArray[quadIdx] = quadIdx;
        }
        MixinBufferBuilder.mergeSort(indicesArray, distanceArray);
        BitSet bits = new BitSet();
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer tmp = stack.mallocFloat(vertexSizeInteger * 4);
            int l = bits.nextClearBit(0);
            while (l < indicesArray.length) {
                int m = indicesArray[l];
                if (m != l) {
                    MixinBufferBuilder.sliceQuad(floatBuffer, m, quadStride, quadStart);
                    tmp.clear();
                    tmp.put(floatBuffer);
                    int n = m;
                    int o = indicesArray[m];
                    while (n != l) {
                        MixinBufferBuilder.sliceQuad(floatBuffer, o, quadStride, quadStart);
                        FloatBuffer floatBuffer3 = floatBuffer.slice();
                        MixinBufferBuilder.sliceQuad(floatBuffer, n, quadStride, quadStart);
                        floatBuffer.put(floatBuffer3);
                        bits.set(n);
                        n = o;
                        o = indicesArray[o];
                    }
                    MixinBufferBuilder.sliceQuad(floatBuffer, l, quadStride, quadStart);
                    tmp.flip();
                    floatBuffer.put(tmp);
                }
                bits.set(l);
                l = bits.nextClearBit(l + 1);
            }
        }
    }

    private static void mergeSort(int[] indicesArray, float[] distanceArray) {
        MixinBufferBuilder.mergeSort(indicesArray, 0, indicesArray.length, distanceArray, Arrays.copyOf(indicesArray, indicesArray.length));
    }

    private static void sliceQuad(FloatBuffer floatBuffer, int quadIdx, int quadStride, int quadStart) {
        int base = quadStart + quadIdx * quadStride;
        ((Buffer)floatBuffer).limit(base + quadStride);
        ((Buffer)floatBuffer).position(base);
    }

    private static float getDistanceSq(FloatBuffer buffer, float xCenter, float yCenter, float zCenter, int stride, int start) {
        int vertexBase = start;
        float x1 = buffer.get(vertexBase);
        float y1 = buffer.get(vertexBase + 1);
        float z1 = buffer.get(vertexBase + 2);
        float x2 = buffer.get(vertexBase += stride);
        float y2 = buffer.get(vertexBase + 1);
        float z2 = buffer.get(vertexBase + 2);
        float x3 = buffer.get(vertexBase += stride);
        float y3 = buffer.get(vertexBase + 1);
        float z3 = buffer.get(vertexBase + 2);
        float x4 = buffer.get(vertexBase += stride);
        float y4 = buffer.get(vertexBase + 1);
        float z4 = buffer.get(vertexBase + 2);
        float xDist = (x1 + x2 + x3 + x4) * 0.25f - xCenter;
        float yDist = (y1 + y2 + y3 + y4) * 0.25f - yCenter;
        float zDist = (z1 + z2 + z3 + z4) * 0.25f - zCenter;
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    private static void mergeSort(int[] a, int from, int to, float[] dist, int[] supp) {
        int len = to - from;
        if (len < 16) {
            MixinBufferBuilder.insertionSort(a, from, to, dist);
            return;
        }
        int mid = from + to >>> 1;
        MixinBufferBuilder.mergeSort(supp, from, mid, dist, a);
        MixinBufferBuilder.mergeSort(supp, mid, to, dist, a);
        if (Floats.compare((float)dist[supp[mid]], (float)dist[supp[mid - 1]]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && Floats.compare((float)dist[supp[q]], (float)dist[supp[p]]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    private static void insertionSort(int[] a, int from, int to, float[] dist) {
        int i = from;
        while (++i < to) {
            int t = a[i];
            int j = i;
            int u = a[j - 1];
            while (Floats.compare((float)dist[u], (float)dist[t]) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }
}

