/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.chunk_rendering;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListenerManager;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientChunkProvider.class})
public abstract class MixinClientChunkManager
implements ChunkStatusListenerManager {
    private final LongOpenHashSet loadedChunks = new LongOpenHashSet();
    private boolean needsTrackingUpdate = false;
    private ChunkStatusListener listener;

    @Shadow
    @Nullable
    public abstract Chunk func_212849_a_(int var1, int var2, ChunkStatus var3, boolean var4);

    @Inject(method={"loadChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;onChunkLoaded(II)V", shift=At.Shift.AFTER)})
    private void afterLoadChunkFromPacket(int chunkX, int chunkZ, BiomeContainer biomeContainerIn, PacketBuffer packetIn, CompoundNBT nbtTagIn, int sizeIn, boolean fullChunk, CallbackInfoReturnable<Chunk> cir) {
        if (this.listener != null && this.loadedChunks.add(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ))) {
            this.listener.onChunkAdded(chunkX, chunkZ);
        }
    }

    @Inject(method={"unloadChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientChunkProvider$ChunkArray;unload(ILnet/minecraft/world/chunk/Chunk;Lnet/minecraft/world/chunk/Chunk;)Lnet/minecraft/world/chunk/Chunk;", shift=At.Shift.AFTER)})
    private void afterUnloadChunk(int x, int z, CallbackInfo ci) {
        if (this.listener != null && this.loadedChunks.remove(ChunkPos.func_77272_a((int)x, (int)z))) {
            this.listener.onChunkRemoved(x, z);
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void afterTick(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        if (!this.needsTrackingUpdate) {
            return;
        }
        LongIterator it = this.loadedChunks.iterator();
        while (it.hasNext()) {
            int z;
            long pos = it.nextLong();
            int x = ChunkPos.func_212578_a((long)pos);
            if (this.func_212849_a_(x, z = ChunkPos.func_212579_b((long)pos), ChunkStatus.field_222617_m, false) != null) continue;
            it.remove();
            if (this.listener == null) continue;
            this.listener.onChunkRemoved(x, z);
        }
        this.needsTrackingUpdate = false;
    }

    @Inject(method={"setCenter(II)V"}, at={@At(value="RETURN")})
    private void afterChunkMapCenterChanged(int x, int z, CallbackInfo ci) {
        this.needsTrackingUpdate = true;
    }

    @Inject(method={"setViewDistance"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientChunkProvider$ChunkArray;replace(ILnet/minecraft/world/chunk/Chunk;)V", shift=At.Shift.AFTER)})
    private void afterLoadDistanceChanged(int loadDistance, CallbackInfo ci) {
        this.needsTrackingUpdate = true;
    }

    @Override
    public void setListener(ChunkStatusListener listener) {
        this.listener = listener;
    }

    @Mixin(targets={"net/minecraft/client/multiplayer/ClientChunkProvider$ChunkArray"})
    public static class MixinClientChunkMap {
        @Mutable
        @Shadow
        @Final
        private AtomicReferenceArray<Chunk> field_217195_b;
        @Mutable
        @Shadow
        @Final
        private int field_217196_c;
        @Mutable
        @Shadow
        @Final
        private int field_217197_d;
        private int factor;

        @Inject(method={"<init>"}, at={@At(value="RETURN")})
        private void reinit(ClientChunkProvider outer, int viewDistanceIn, CallbackInfo ci) {
            this.field_217196_c = viewDistanceIn;
            this.field_217197_d = MathHelper.func_151236_b((int)(viewDistanceIn * 2 + 1));
            this.factor = this.field_217197_d - 1;
            this.field_217195_b = new AtomicReferenceArray(this.field_217197_d * this.field_217197_d);
        }

        @Overwrite
        private int func_217191_a(int chunkX, int chunkZ) {
            return (chunkZ & this.factor) * this.field_217197_d + (chunkX & this.factor);
        }
    }
}

