/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.client.util.rand.XoRoShiRoRandom;
import me.jellysquid.mods.sodium.client.world.biome.ItemColorsExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ItemRenderer.class})
public class MixinItemRenderer {
    private final XoRoShiRoRandom random = new XoRoShiRoRandom();
    @Shadow
    @Final
    private ItemColors field_184395_f;

    @Overwrite
    public void func_229114_a_(IBakedModel model, ItemStack stack, int light, int overlay, MatrixStack matrices, IVertexBuilder vertices) {
        XoRoShiRoRandom random = this.random;
        for (Direction direction : DirectionUtil.ALL_DIRECTIONS) {
            List quads = model.func_200117_a(null, direction, (Random)random.setSeedAndReturn(42L));
            if (quads.isEmpty()) continue;
            this.func_229112_a_(matrices, vertices, quads, stack, light, overlay);
        }
        List quads = model.func_200117_a(null, null, (Random)random.setSeedAndReturn(42L));
        if (!quads.isEmpty()) {
            this.func_229112_a_(matrices, vertices, quads, stack, light, overlay);
        }
    }

    @Overwrite
    public void func_229112_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, List<BakedQuad> quadsIn, ItemStack itemStackIn, int combinedLightIn, int combinedOverlayIn) {
        MatrixStack.Entry entry = matrixStackIn.func_227866_c_();
        IItemColor colorProvider = null;
        QuadVertexSink drain = VertexDrain.of(bufferIn).createSink(VanillaVertexTypes.QUADS);
        drain.ensureCapacity(quadsIn.size() * 4);
        for (BakedQuad bakedQuad : quadsIn) {
            int color = -1;
            if (!itemStackIn.func_190926_b() && bakedQuad.func_178212_b()) {
                if (colorProvider == null) {
                    colorProvider = ((ItemColorsExtended)this.field_184395_f).getColorProvider(itemStackIn);
                }
                color = colorProvider == null ? ColorARGB.toABGR(this.field_184395_f.func_186728_a(itemStackIn, bakedQuad.func_178211_c()), 255) : ColorARGB.toABGR(colorProvider.getColor(itemStackIn, bakedQuad.func_178211_c()), 255);
            }
            ModelQuadView quad = (ModelQuadView)bakedQuad;
            for (int i = 0; i < 4; ++i) {
                int finalColor = color;
                try {
                    if (bakedQuad.func_178212_b()) {
                        finalColor = this.multABGRInts(quad.getColor(quad.getColorIndex()), color);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                drain.writeQuad(entry, quad.getX(i), quad.getY(i), quad.getZ(i), finalColor, quad.getTexU(i), quad.getTexV(i), combinedLightIn, combinedOverlayIn, ModelQuadUtil.getFacingNormal(bakedQuad.func_178210_d()));
            }
            SpriteUtil.markSpriteActive(quad.getSprite());
        }
        drain.flush();
    }

    private int multABGRInts(int colorA, int colorB) {
        int a = (int)((float)ColorABGR.unpackAlpha(colorA) / 255.0f * ((float)ColorABGR.unpackAlpha(colorB) / 255.0f) * 255.0f);
        int b = (int)((float)ColorABGR.unpackBlue(colorA) / 255.0f * ((float)ColorABGR.unpackBlue(colorB) / 255.0f) * 255.0f);
        int g = (int)((float)ColorABGR.unpackGreen(colorA) / 255.0f * ((float)ColorABGR.unpackGreen(colorB) / 255.0f) * 255.0f);
        int r = (int)((float)ColorABGR.unpackRed(colorA) / 255.0f * ((float)ColorABGR.unpackRed(colorB) / 255.0f) * 255.0f);
        return ColorABGR.pack(r, g, b, a);
    }
}

