/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.gen.chunk_region;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenRegion.class})
public abstract class ChunkRegionMixin {
    @Shadow
    @Final
    private ChunkPos field_241160_n_;
    @Shadow
    @Final
    private int field_217380_e;
    private IChunk[] chunksArr;
    private int minChunkX;
    private int minChunkZ;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(ServerWorld world, List<IChunk> chunks, CallbackInfo ci) {
        this.minChunkX = this.field_241160_n_.field_77276_a;
        this.minChunkZ = this.field_241160_n_.field_77275_b;
        this.chunksArr = chunks.toArray(new IChunk[0]);
    }

    @Overwrite
    public BlockState func_180495_p(BlockPos pos) {
        int x = (pos.func_177958_n() >> 4) - this.minChunkX;
        int z = (pos.func_177952_p() >> 4) - this.minChunkZ;
        int w = this.field_217380_e;
        if (x >= 0 && z >= 0 && x < w && z < w) {
            return this.chunksArr[x + z * w].func_180495_p(pos);
        }
        throw new NullPointerException("No chunk exists at " + new ChunkPos(pos));
    }

    @Overwrite
    public FluidState func_204610_c(BlockPos pos) {
        return this.func_180495_p(pos).func_204520_s();
    }
}

