/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.gen.fast_noise_interpolation;

import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.ImprovedNoiseGenerator;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={NoiseChunkGenerator.class})
public class NoiseChunkGeneratorMixin {
    @Shadow
    @Final
    private OctavesNoiseGenerator field_222568_o;
    @Shadow
    @Final
    private OctavesNoiseGenerator field_222569_p;
    @Shadow
    @Final
    private OctavesNoiseGenerator field_222570_q;

    @Overwrite
    public double func_222552_a(int x, int y, int z, double horizontalScale, double verticalScale, double horizontalStretch, double verticalStretch) {
        double frequency = 1.0;
        double interpolationValue = 0.0;
        for (int octave = 0; octave < 8; ++octave) {
            double scaledVerticalScale = verticalStretch * frequency;
            double scaledY = (double)y * scaledVerticalScale;
            interpolationValue += NoiseChunkGeneratorMixin.sampleOctave(this.field_222570_q.func_215463_a(octave), OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalStretch * frequency)), OctavesNoiseGenerator.func_215461_a((double)scaledY), OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalStretch * frequency)), scaledVerticalScale, scaledY, frequency);
            frequency /= 2.0;
        }
        double clampedInterpolation = (interpolationValue / 10.0 + 1.0) / 2.0;
        if (clampedInterpolation >= 1.0) {
            frequency = 1.0;
            double noise = 0.0;
            for (int octave = 0; octave < 16; ++octave) {
                double scaledVerticalScale = verticalScale * frequency;
                double scaledY = (double)y * scaledVerticalScale;
                noise += NoiseChunkGeneratorMixin.sampleOctave(this.field_222569_p.func_215463_a(octave), OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalScale * frequency)), OctavesNoiseGenerator.func_215461_a((double)scaledY), OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalScale * frequency)), scaledVerticalScale, scaledY, frequency);
                frequency /= 2.0;
            }
            return noise / 512.0;
        }
        if (clampedInterpolation <= 0.0) {
            frequency = 1.0;
            double noise = 0.0;
            for (int octave = 0; octave < 16; ++octave) {
                double scaledVerticalScale = verticalScale * frequency;
                double scaledY = (double)y * scaledVerticalScale;
                noise += NoiseChunkGeneratorMixin.sampleOctave(this.field_222568_o.func_215463_a(octave), OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalScale * frequency)), OctavesNoiseGenerator.func_215461_a((double)scaledY), OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalScale * frequency)), scaledVerticalScale, scaledY, frequency);
                frequency /= 2.0;
            }
            return noise / 512.0;
        }
        frequency = 1.0;
        double lowerNoise = 0.0;
        double upperNoise = 0.0;
        for (int octave = 0; octave < 16; ++octave) {
            double scaledVerticalScale = verticalScale * frequency;
            double scaledY = (double)y * scaledVerticalScale;
            double xVal = OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalScale * frequency));
            double yVal = OctavesNoiseGenerator.func_215461_a((double)scaledY);
            double zVal = OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalScale * frequency));
            upperNoise += NoiseChunkGeneratorMixin.sampleOctave(this.field_222569_p.func_215463_a(octave), xVal, yVal, zVal, scaledVerticalScale, scaledY, frequency);
            lowerNoise += NoiseChunkGeneratorMixin.sampleOctave(this.field_222568_o.func_215463_a(octave), xVal, yVal, zVal, scaledVerticalScale, scaledY, frequency);
            frequency /= 2.0;
        }
        return MathHelper.func_219803_d((double)clampedInterpolation, (double)(lowerNoise / 512.0), (double)(upperNoise / 512.0));
    }

    private static double sampleOctave(ImprovedNoiseGenerator sampler, double x, double y, double z, double scaledVerticalScale, double scaledY, double frequency) {
        return sampler.func_215456_a(x, y, z, scaledVerticalScale, scaledY) / frequency;
    }
}

