/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs;

import com.infamous.dungeons_libraries.utils.AbilityHelper;
import com.infamous.dungeons_mobs.capabilities.convertible.Convertible;
import com.infamous.dungeons_mobs.capabilities.convertible.ConvertibleHelper;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.entities.creepers.IcyCreeperEntity;
import com.infamous.dungeons_mobs.entities.illagers.IllusionerCloneEntity;
import com.infamous.dungeons_mobs.entities.summonables.ConstructEntity;
import com.infamous.dungeons_mobs.entities.undead.FrozenZombieEntity;
import com.infamous.dungeons_mobs.goals.SmartTridentAttackGoal;
import com.infamous.dungeons_mobs.interfaces.IHasItemStackData;
import com.infamous.dungeons_mobs.mixin.GoalSelectorAccessor;
import com.infamous.dungeons_mobs.mixin.TridentEntityAccessor;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_mobs")
public class MobEvents {
    private static ArmorStand DUMMY_TARGET;
    public static Random random;

    @SubscribeEvent
    public static void onSetAttackTarget(LivingChangeTargetEvent event) {
        LivingEntity attacker = event.getEntityLiving();
        Level level = attacker.f_19853_;
        LivingEntity target = event.getNewTarget();
        if (attacker instanceof Mob && target instanceof Mob && AbilityHelper.isAlly((LivingEntity)attacker, (LivingEntity)target)) {
            MobEvents.createDummyTarget(level);
            if (attacker instanceof NeutralMob) {
                ((NeutralMob)attacker).m_6925_((UUID)null);
                ((NeutralMob)attacker).m_7870_(0);
            }
            ((Mob)attacker).m_6710_((LivingEntity)DUMMY_TARGET);
            attacker.m_6703_((LivingEntity)DUMMY_TARGET);
        }
    }

    private static void createDummyTarget(Level level) {
        if (DUMMY_TARGET == null && (DUMMY_TARGET = (ArmorStand)EntityType.f_20529_.m_20615_(level)) != null) {
            DUMMY_TARGET.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof Drowned) {
            Drowned drownedEntity = (Drowned)event.getEntity();
            ((GoalSelectorAccessor)drownedEntity.f_21345_).getAvailableGoals().removeIf(pg -> pg.m_26012_() == 2 && pg.m_26015_() instanceof RangedAttackGoal);
            drownedEntity.f_21345_.m_25352_(2, (Goal)new SmartTridentAttackGoal((RangedAttackMob)drownedEntity, 1.0, 40, 10.0f));
        }
        if (event.getEntity() instanceof ThrownTrident) {
            ((IHasItemStackData)event.getEntity()).setDataItem(((TridentEntityAccessor)event.getEntity()).getTridentItem());
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Mob && ConvertibleHelper.convertsInWater((Mob)livingEntity)) {
            Mob mob = (Mob)livingEntity;
            if (!mob.f_19853_.f_46443_ && mob.m_6084_() && !mob.m_21525_()) {
                Convertible convertibleCap = ConvertibleHelper.getConvertibleCapability((Entity)mob);
                if (convertibleCap == null) {
                    return;
                }
                convertibleCap.setCanConvert(mob.m_204029_(FluidTags.f_13131_));
                if (convertibleCap.isConverting()) {
                    convertibleCap.tickConversionTime();
                    EntityType<? extends Mob> convertToType = ConvertibleHelper.getDrowningConvertTo(mob);
                    if (convertibleCap.getConversionTime() < 0) {
                        if (ForgeEventFactory.canLivingConvert((LivingEntity)mob, convertToType, convertibleCap::setConversionTime)) {
                            convertibleCap.doConversion(mob, convertToType, ConvertibleHelper::onDrownedAndConvertedTo);
                        }
                    }
                } else if (convertibleCap.canConvert()) {
                    convertibleCap.tickPrepareConversionTime();
                    if (convertibleCap.getPrepareConversionTime() >= 600) {
                        convertibleCap.startConversion(300);
                    }
                } else {
                    convertibleCap.setPrepareConversionTime(-1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSnowballHitPlayer(ProjectileImpactEvent event) {
        Snowball snowballEntity;
        Entity shooter;
        if (event.getEntity() instanceof Snowball && (shooter = (snowballEntity = (Snowball)event.getEntity()).m_37282_()) instanceof FrozenZombieEntity) {
            EntityHitResult entityRayTraceResult;
            snowballEntity.m_5496_((SoundEvent)ModSoundEvents.FROZEN_ZOMBIE_SNOWBALL_LAND.get(), 1.0f, 1.0f);
            HitResult rayTraceResult = event.getRayTraceResult();
            if (rayTraceResult instanceof EntityHitResult && (entityRayTraceResult = (EntityHitResult)rayTraceResult).m_82443_() instanceof Player) {
                Player playerEntity = (Player)entityRayTraceResult.m_82443_();
                playerEntity.m_6469_(DamageSource.m_19361_((Entity)snowballEntity, (Entity)shooter), 2.0f);
                int i = 0;
                if (event.getEntity().f_19853_.m_46791_() == Difficulty.NORMAL) {
                    i = 3;
                } else if (event.getEntity().f_19853_.m_46791_() == Difficulty.HARD) {
                    i = 6;
                }
                if (i > 0) {
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, i * 20, 1));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSnowballDamageMob(LivingHurtEvent event) {
        if (event.getSource().m_7640_() instanceof Snowball && event.getSource().m_7639_() instanceof FrozenZombieEntity && !(event.getEntityLiving() instanceof Player)) {
            event.setAmount(event.getAmount() + 2.0f);
            int i = 0;
            if (event.getEntityLiving().f_19853_.m_46791_() == Difficulty.NORMAL) {
                i = 3;
            } else if (event.getEntityLiving().f_19853_.m_46791_() == Difficulty.HARD) {
                i = 6;
            }
            if (i > 0) {
                event.getEntityLiving().m_7292_(new MobEffectInstance(MobEffects.f_19597_, i * 20, 1));
            }
        }
    }

    @SubscribeEvent
    public static void onIllusionerCloneArrowHit(ProjectileImpactEvent event) {
        AbstractArrow arrowEntity;
        Entity shooter;
        if (event.getEntity() instanceof AbstractArrow && (shooter = (arrowEntity = (AbstractArrow)event.getEntity()).m_37282_()) instanceof IllusionerCloneEntity) {
            arrowEntity.m_5496_((SoundEvent)ModSoundEvents.ILLUSIONER_CLONE_ARROW_HIT.get(), 1.0f, 1.0f);
            if (!arrowEntity.f_19853_.f_46443_) {
                arrowEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                for (int i = 0; i < 2; ++i) {
                    double d0 = random.nextGaussian() * 0.02;
                    double d1 = random.nextGaussian() * 0.02;
                    double d2 = random.nextGaussian() * 0.02;
                    arrowEntity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, arrowEntity.m_20208_(1.0), arrowEntity.m_20187_(), arrowEntity.m_20262_(1.0), d0, d1, d2);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onIceCreeperExplosion(EntityMobGriefingEvent event) {
        if (event.getEntity() instanceof IcyCreeperEntity) {
            IcyCreeperEntity iceCreeperEntity = (IcyCreeperEntity)event.getEntity();
            iceCreeperEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 600));
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        MobEvents.handlePillarProtection(event);
        if (event.getExplosion().m_46079_() instanceof IcyCreeperEntity) {
            if (!((Boolean)DungeonsMobsConfig.COMMON.ENABLE_ICY_CREEPER_GRIEFING.get()).booleanValue()) {
                event.getAffectedBlocks().clear();
            }
            List entityList = event.getAffectedEntities();
            for (Entity entity : entityList) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 600));
            }
        }
    }

    private static void handlePillarProtection(ExplosionEvent.Detonate event) {
        boolean pillarsArePresent;
        Explosion explosion = event.getExplosion();
        Entity source = explosion.getExploder();
        BlockPos detonationOrigin = new BlockPos(explosion.getPosition());
        List entityList = event.getAffectedEntities();
        ArrayList<ConstructEntity> potentialProtectingPillars = new ArrayList<ConstructEntity>(Collections.emptyList());
        for (Entity entity : entityList) {
            if (!(entity instanceof ConstructEntity) || entity == source) continue;
            potentialProtectingPillars.add((ConstructEntity)entity);
        }
        boolean bl = pillarsArePresent = !potentialProtectingPillars.isEmpty();
        if (!pillarsArePresent) {
            return;
        }
        Iterator it = entityList.iterator();
        while (it.hasNext()) {
            boolean protectedByPillar;
            Entity currentEntity = (Entity)it.next();
            boolean notAPillar = !(currentEntity instanceof ConstructEntity);
            if (!notAPillar || currentEntity == null || !(protectedByPillar = MobEvents.entityProtectedByPillar(currentEntity, potentialProtectingPillars, detonationOrigin))) continue;
            it.remove();
        }
    }

    private static boolean entityProtectedByPillar(Entity entity, List<ConstructEntity> pillarEntities, BlockPos detonationOrigin) {
        if (pillarEntities.isEmpty()) {
            return false;
        }
        BlockPos entityPos = entity.m_142538_();
        for (ConstructEntity pillarEntity : pillarEntities) {
            double distanceExplosionToEntity;
            double distanceExplosionToPillar;
            BlockPos pillarPos = pillarEntity.m_142538_();
            double widthAllowance = pillarEntity.m_20205_();
            double distanceEntityToPillar = Math.sqrt(entityPos.m_123331_((Vec3i)pillarPos));
            boolean canProtect = distanceEntityToPillar + (distanceExplosionToPillar = Math.sqrt(detonationOrigin.m_123331_((Vec3i)pillarPos))) <= (distanceExplosionToEntity = Math.sqrt(detonationOrigin.m_123331_((Vec3i)entityPos))) + widthAllowance;
            if (!canProtect) continue;
            return true;
        }
        return false;
    }

    static {
        random = new Random();
    }
}

