/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.ocean;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.water.DrownedNecromancerEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.molang.MolangParser;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.resource.GeckoLibCache;

@OnlyIn(value=Dist.CLIENT)
public class DrownedNecromancerModel
extends AnimatedGeoModel<DrownedNecromancerEntity> {
    public ResourceLocation getAnimationFileLocation(DrownedNecromancerEntity entity) {
        return new ResourceLocation("dungeons_mobs", "animations/drowned_necromancer.animation.json");
    }

    public ResourceLocation getModelLocation(DrownedNecromancerEntity entity) {
        return new ResourceLocation("dungeons_mobs", "geo/drowned_necromancer.geo.json");
    }

    public ResourceLocation getTextureLocation(DrownedNecromancerEntity entity) {
        return new ResourceLocation("dungeons_mobs", "textures/entity/ocean/drowned_necromancer.png");
    }

    public void setCustomAnimations(DrownedNecromancerEntity entity, int uniqueID, AnimationEvent customPredicate) {
        super.setCustomAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("bipedHead");
        IBone cape = this.getAnimationProcessor().getBone("bipedCape");
        IBone particles = this.getAnimationProcessor().getBone("staffParticles");
        if (particles instanceof GeoBone && entity.isSpellcasting()) {
            GeoBone particleBone = (GeoBone)particles;
            entity.f_19853_.m_7106_((ParticleOptions)(entity.m_20072_() ? ParticleTypes.f_123774_ : (ParticleOptions)ModParticleTypes.NECROMANCY.get()), particleBone.getWorldPosition().f_86214_, particleBone.getWorldPosition().f_86215_, particleBone.getWorldPosition().f_86216_, 0.0, 0.0, 0.0);
        }
        cape.setHidden(entity.m_6844_(EquipmentSlot.CHEST).m_41720_() != entity.getArmorSet().getChest().get());
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }

    public void setMolangQueries(IAnimatable animatable, double currentTick) {
        super.setMolangQueries(animatable, currentTick);
        MolangParser parser = GeckoLibCache.getInstance().parser;
        LivingEntity livingEntity = (LivingEntity)animatable;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        parser.setValue("query.ground_speed", () -> groundSpeed * 20.0f);
    }
}

