/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.undead;

import com.infamous.dungeons_mobs.entities.undead.WraithEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class WraithModel
extends AnimatedGeoModel<WraithEntity> {
    public ResourceLocation getAnimationFileLocation(WraithEntity entity) {
        return new ResourceLocation("dungeons_mobs", "animations/wraith.animation.json");
    }

    public ResourceLocation getModelLocation(WraithEntity entity) {
        return new ResourceLocation("dungeons_mobs", "geo/wraith.geo.json");
    }

    public ResourceLocation getTextureLocation(WraithEntity entity) {
        return new ResourceLocation("dungeons_mobs", "textures/entity/wraith/wraith.png");
    }

    public void setCustomAnimations(WraithEntity entity, int uniqueID, AnimationEvent customPredicate) {
        super.setCustomAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("bipedHead");
        IBone cape = this.getAnimationProcessor().getBone("bipedCape");
        cape.setHidden(true);
        IBone leftHand = this.getAnimationProcessor().getBone("bipedHandLeft");
        IBone rightHand = this.getAnimationProcessor().getBone("bipedHandRight");
        if (entity.f_19797_ % 2 == 0 && rightHand instanceof GeoBone && leftHand instanceof GeoBone && entity.isSpellcasting()) {
            GeoBone leftHandBone = (GeoBone)leftHand;
            GeoBone rightHandBone = (GeoBone)rightHand;
            entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, leftHandBone.getWorldPosition().f_86214_, leftHandBone.getWorldPosition().f_86215_, leftHandBone.getWorldPosition().f_86216_, entity.m_21187_().nextGaussian() * 0.01, entity.m_21187_().nextGaussian() * 0.01, entity.m_21187_().nextGaussian() * 0.01);
            entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, rightHandBone.getWorldPosition().f_86214_, rightHandBone.getWorldPosition().f_86215_, rightHandBone.getWorldPosition().f_86216_, entity.m_21187_().nextGaussian() * 0.01, entity.m_21187_().nextGaussian() * 0.01, entity.m_21187_().nextGaussian() * 0.01);
        }
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

