/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.illager;

import com.infamous.dungeons_mobs.client.models.armor.IllagerArmorModel;
import com.infamous.dungeons_mobs.client.models.geom.ModModelLayers;
import com.infamous.dungeons_mobs.client.models.illager.IllagerBipedModel;
import com.infamous.dungeons_mobs.entities.illagers.MountaineerEntity;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Vindicator;

public class CustomVindicatorRenderer
extends MobRenderer<Vindicator, IllagerBipedModel<Vindicator>> {
    private static final ResourceLocation GOLD_ARMORED_VINDICATOR_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/gold_armored_vindicator.png");
    private static final ResourceLocation DIAMOND_ARMORED_VINDICATOR_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/diamond_armored_vindicator.png");
    private static final ResourceLocation VINDICATOR_TEXTURE = new ResourceLocation("textures/entity/illager/vindicator.png");
    private static final ResourceLocation MOUNTAINEER_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/mountaineer.png");
    private static final ResourceLocation VINDICATOR_CHEF_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/vindicator_chef.png");

    public CustomVindicatorRenderer(EntityRendererProvider.Context renderContext) {
        super(renderContext, new IllagerBipedModel(renderContext.m_174023_(ModModelLayers.BIPED_ILLAGER_MODEL)), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new IllagerArmorModel(renderContext.m_174023_(ModModelLayers.ILLAGER_ARMOR_MODEL_INNER_LAYER)), new IllagerArmorModel(renderContext.m_174023_(ModModelLayers.ILLAGER_ARMOR_MODEL_OUTER_LAYER))));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, renderContext.m_174027_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer<Vindicator, IllagerBipedModel<Vindicator>>((RenderLayerParent)this){

            public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Vindicator vindicatorEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                if (vindicatorEntity.m_5912_() || vindicatorEntity.m_6768_() == AbstractIllager.IllagerArmPose.NEUTRAL) {
                    super.m_6494_(matrixStackIn, bufferIn, packedLightIn, (LivingEntity)vindicatorEntity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
            }
        });
    }

    protected void scale(Vindicator vindicatorEntity, PoseStack matrixStack, float v) {
        float scaleFactor = 0.9375f;
        matrixStack.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        super.m_7546_((LivingEntity)vindicatorEntity, matrixStack, v);
    }

    public ResourceLocation getTextureLocation(Vindicator entity) {
        if (entity instanceof MountaineerEntity) {
            return MOUNTAINEER_TEXTURE;
        }
        if (entity.m_6844_(EquipmentSlot.HEAD).m_41720_().equals(ModItems.DIAMOND_VINDICATOR_HELMET.get())) {
            return DIAMOND_ARMORED_VINDICATOR_TEXTURE;
        }
        if (entity.m_6844_(EquipmentSlot.HEAD).m_41720_().equals(ModItems.GOLD_VINDICATOR_HELMET.get())) {
            return GOLD_ARMORED_VINDICATOR_TEXTURE;
        }
        return VINDICATOR_TEXTURE;
    }
}

