/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.illager;

import com.infamous.dungeons_mobs.client.models.illager.ReplacedPillagerModel;
import com.infamous.dungeons_mobs.client.renderer.util.ModExtentedGeoReplacedEntityRenderer;
import com.infamous.dungeons_mobs.entities.illagers.ReplacedPillagerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;

public class ReplacedPillagerRenderer
extends ModExtentedGeoReplacedEntityRenderer<ReplacedPillagerEntity> {
    public ReplacedPillagerRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new ReplacedPillagerModel(), new ReplacedPillagerEntity());
    }

    @Override
    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.isArmorBone(bone)) {
            bone.setCubesHidden(true);
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Override
    protected boolean isArmorBone(GeoBone bone) {
        return bone.getName().startsWith("armor");
    }

    @Override
    @Nullable
    protected ResourceLocation getTextureForBone(String s, ReplacedPillagerEntity currentEntity) {
        return null;
    }

    @Override
    protected ItemStack getHeldItemForBone(String boneName, ReplacedPillagerEntity currentEntity) {
        switch (boneName) {
            case "bipedHandLeft": {
                return currentEntity.getMob().m_21526_() ? this.mainHand : this.offHand;
            }
            case "bipedHandRight": {
                return currentEntity.getMob().m_21526_() ? this.offHand : this.mainHand;
            }
        }
        return null;
    }

    @Override
    protected ItemTransforms.TransformType getCameraTransformForItemAtBone(ItemStack boneItem, String boneName) {
        switch (boneName) {
            case "bipedHandLeft": {
                return ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
            case "bipedHandRight": {
                return ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
        }
        return ItemTransforms.TransformType.NONE;
    }

    @Override
    protected void preRenderItem(PoseStack stack, ItemStack item, String boneName, ReplacedPillagerEntity currentEntity, IBone bone) {
        if (item == this.mainHand || item == this.offHand) {
            stack.m_85841_(1.1f, 1.1f, 1.1f);
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            boolean shieldFlag = item.m_41720_() instanceof ShieldItem;
            if (item == this.mainHand) {
                if (shieldFlag) {
                    stack.m_85837_(0.0, 0.125, -0.25);
                }
            } else if (shieldFlag) {
                stack.m_85837_(-0.15, 0.125, 0.05);
                stack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            }
        }
    }

    @Override
    protected void postRenderItem(PoseStack matrixStack, ItemStack item, String boneName, ReplacedPillagerEntity currentEntity, IBone bone) {
    }

    @Override
    protected BlockState getHeldBlockForBone(String boneName, ReplacedPillagerEntity currentEntity) {
        return null;
    }

    @Override
    protected void preRenderBlock(PoseStack matrixStack, BlockState block, String boneName, ReplacedPillagerEntity currentEntity) {
    }

    @Override
    protected void postRenderBlock(PoseStack matrixStack, BlockState block, String boneName, ReplacedPillagerEntity currentEntity) {
    }

    @Override
    @Nullable
    protected ItemStack getArmorForBone(String boneName, ReplacedPillagerEntity currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return this.boots;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return this.leggings;
            }
            case "armorBipedBody": 
            case "armorBipedRightArm": 
            case "armorBipedLeftArm": 
            case "armorIllagerRightArm": 
            case "armorIllagerLeftArm": {
                return this.chestplate;
            }
            case "armorBipedHead": {
                return this.helmet;
            }
        }
        return null;
    }

    @Override
    protected EquipmentSlot getEquipmentSlotForArmorBone(String boneName, ReplacedPillagerEntity currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return EquipmentSlot.FEET;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return EquipmentSlot.LEGS;
            }
            case "armorBipedRightHand": {
                return !currentEntity.getMob().m_21526_() ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            }
            case "armorBipedLeftHand": {
                return currentEntity.getMob().m_21526_() ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            }
            case "armorBipedRightArm": 
            case "armorBipedLeftArm": 
            case "armorIllagerRightArm": 
            case "armorIllagerLeftArm": 
            case "armorBipedBody": {
                return EquipmentSlot.CHEST;
            }
            case "armorBipedHead": {
                return EquipmentSlot.HEAD;
            }
        }
        return null;
    }

    @Override
    protected ModelPart getArmorPartForBone(String name, HumanoidModel<?> armorModel) {
        switch (name) {
            case "armorBipedLeftFoot": 
            case "armorBipedLeftLeg": {
                return armorModel.f_102814_;
            }
            case "armorBipedRightFoot": 
            case "armorBipedRightLeg": {
                return armorModel.f_102813_;
            }
            case "armorBipedRightArm": 
            case "armorIllagerRightArm": {
                return armorModel.f_102811_;
            }
            case "armorBipedLeftArm": 
            case "armorIllagerLeftArm": {
                return armorModel.f_102812_;
            }
            case "armorBipedBody": {
                return armorModel.f_102810_;
            }
            case "armorBipedHead": {
                return armorModel.f_102808_;
            }
        }
        return null;
    }

    @Override
    protected void prepareArmorPositionAndScale(GeoBone bone, List<ModelPart.Cube> cubeList, ModelPart sourceLimb, PoseStack stack, boolean geoArmor, boolean modMatrixRot) {
        super.prepareArmorPositionAndScale(bone, cubeList, sourceLimb, stack, geoArmor, modMatrixRot);
        if (bone.getName().equals("armorBipedHead") && geoArmor && this.helmet.m_41720_().getRegistryName().m_135827_().equals("dungeons_mobs")) {
            stack.m_85837_(0.0, 0.125, 0.0);
        }
    }
}

