/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

@OnlyIn(value=Dist.CLIENT)
public class PulsatingGlowLayer<T extends LivingEntity>
extends GeoLayerRenderer<T> {
    public ResourceLocation textureLocation;
    public float pulseSpeed;
    public float pulseAmount;
    public float minimumPulseAmount;

    public PulsatingGlowLayer(IGeoRenderer<T> endermanReplacementRenderer, ResourceLocation textureLocation, float pulseSpeed, float pulseAmount, float minimumPulseAmount) {
        super(endermanReplacementRenderer);
        this.textureLocation = textureLocation;
        this.pulseSpeed = pulseSpeed;
        this.pulseAmount = pulseAmount;
        this.minimumPulseAmount = minimumPulseAmount;
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        GeoModelProvider geomodel = this.getEntityModel();
        float glow = Math.max(this.minimumPulseAmount, Mth.m_14089_((float)(ageInTicks * this.pulseSpeed)) * this.pulseAmount);
        this.renderModel(geomodel, this.textureLocation, matrixStackIn, bufferIn, packedLightIn, (Entity)entitylivingbaseIn, 1.0f, glow, glow, glow);
    }

    public RenderType getRenderType(ResourceLocation textureLocation) {
        return RenderType.m_110488_((ResourceLocation)textureLocation);
    }
}

