/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.water;

import com.infamous.dungeons_libraries.capabilities.elite.EliteMob;
import com.infamous.dungeons_libraries.capabilities.elite.EliteMobHelper;
import com.infamous.dungeons_mobs.client.renderer.water.CustomDrownedOuterLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Zombie;

public class CustomDrownedRenderer
extends AbstractZombieRenderer<Drowned, DrownedModel<Drowned>> {
    private static final ResourceLocation DROWNED_LOCATION = new ResourceLocation("textures/entity/zombie/drowned.png");
    private static final ResourceLocation SEAWEED_ARMORED_DROWNED_LOCATION = new ResourceLocation("dungeons_mobs", "textures/entity/ocean/seaweed_armored_drowned.png");
    private static final ResourceLocation PALE_ARMORED_DROWNED_LOCATION = new ResourceLocation("dungeons_mobs", "textures/entity/ocean/pale_armored_drowned.png");
    private static final List<ResourceLocation> ARMORED_DROWNED_LOCATIONS = Arrays.asList(SEAWEED_ARMORED_DROWNED_LOCATION, PALE_ARMORED_DROWNED_LOCATION);

    public CustomDrownedRenderer(EntityRendererProvider.Context rendererContext) {
        super(rendererContext, (ZombieModel)new DrownedModel(rendererContext.m_174023_(ModelLayers.f_171136_)), (ZombieModel)new DrownedModel(rendererContext.m_174023_(ModelLayers.f_171137_)), (ZombieModel)new DrownedModel(rendererContext.m_174023_(ModelLayers.f_171138_)));
        this.m_115326_(new CustomDrownedOuterLayer(this, new DrownedModel(rendererContext.m_174023_(ModelLayers.f_171139_))));
    }

    protected void scale(Drowned drowned, PoseStack matrixStack, float p_225620_3_) {
        super.m_7546_((LivingEntity)drowned, matrixStack, p_225620_3_);
    }

    protected void setupRotations(Drowned drowned, PoseStack matrixStack, float p_225621_3_, float p_225621_4_, float p_225621_5_) {
        super.m_7523_((LivingEntity)drowned, matrixStack, p_225621_3_, p_225621_4_, p_225621_5_);
        float swimAmount = drowned.m_20998_(p_225621_5_);
        if (swimAmount > 0.0f) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14179_((float)swimAmount, (float)drowned.m_146909_(), (float)(-10.0f - drowned.m_146909_()))));
        }
    }

    public ResourceLocation m_5478_(Zombie drowned) {
        EliteMob cap = EliteMobHelper.getEliteMobCapability((Entity)drowned);
        if (cap != null && cap.isElite()) {
            return ARMORED_DROWNED_LOCATIONS.get(drowned.m_142049_() % ARMORED_DROWNED_LOCATIONS.size());
        }
        return DROWNED_LOCATION;
    }
}

