/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.water;

import com.infamous.dungeons_mobs.client.models.geom.ModModelLayers;
import com.infamous.dungeons_mobs.client.models.undead.SunkenSkeletonModel;
import com.infamous.dungeons_mobs.entities.water.SunkenSkeletonEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SunkenSkeletonRenderer<T extends SunkenSkeletonEntity>
extends HumanoidMobRenderer<T, SunkenSkeletonModel<T>> {
    private static final ResourceLocation SUNKEN_SKELETON_LOCATION = new ResourceLocation("dungeons_mobs", "textures/entity/ocean/sunken_skeleton.png");
    private static final ResourceLocation RED_CORAL_ARMORED_SUNKEN_SKELETON_LOCATION = new ResourceLocation("dungeons_mobs", "textures/entity/ocean/red_coral_armored_sunken_skeleton.png");
    private static final ResourceLocation YELLOW_CORAL_ARMORED_SUNKEN_SKELETON_LOCATION = new ResourceLocation("dungeons_mobs", "textures/entity/ocean/yellow_coral_armored_sunken_skeleton.png");
    private static final List<ResourceLocation> ARMORED_SKELETON_LOCATIONS = Arrays.asList(RED_CORAL_ARMORED_SUNKEN_SKELETON_LOCATION, YELLOW_CORAL_ARMORED_SUNKEN_SKELETON_LOCATION);

    public SunkenSkeletonRenderer(EntityRendererProvider.Context renderContext) {
        super(renderContext, new SunkenSkeletonModel(renderContext.m_174023_(ModModelLayers.SUNKEN_SKELETON)), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new SunkenSkeletonModel(renderContext.m_174023_(ModelLayers.f_171238_)), new SunkenSkeletonModel(renderContext.m_174023_(ModelLayers.f_171239_))));
    }

    protected void scale(T skeleton, PoseStack matrixStack, float v) {
        super.m_7546_(skeleton, matrixStack, v);
    }

    protected void setupRotations(T skeleton, PoseStack matrixStack, float p_225621_3_, float p_225621_4_, float p_225621_5_) {
        super.m_7523_(skeleton, matrixStack, p_225621_3_, p_225621_4_, p_225621_5_);
        float swimAmount = skeleton.m_20998_(p_225621_5_);
        if (swimAmount > 0.0f) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14179_((float)swimAmount, (float)skeleton.m_146909_(), (float)(-10.0f - skeleton.m_146909_()))));
        }
    }

    public ResourceLocation getTextureLocation(T skeleton) {
        return SUNKEN_SKELETON_LOCATION;
    }
}

