/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DungeonsMobsConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_WRAITH_FIRE_SUMMON;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ICY_CREEPER_GRIEFING;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_MOB_ARMOR_DROPS;
        public static ForgeConfigSpec.ConfigValue<List<? extends String>> NECROMANCER_MOB_SUMMONS;
        public static ForgeConfigSpec.ConfigValue<List<? extends String>> DROWNED_NECROMANCER_MOB_SUMMONS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_FROZEN_ZOMBIE_REPLACES_ZOMBIE;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ICY_CREEPER_REPLACES_CREEPER;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_JUNGLE_ZOMBIE_REPLACES_ZOMBIE;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_MOSSY_SKELETON_REPLACES_SKELETON;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_3D_SLEEVES;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ICEOLOGER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> ICEOLOGER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> ICEOLOGER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> ICEOLOGER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> WRAITH_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> WRAITH_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> WRAITH_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> WRAITH_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> NECROMANCER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> NECROMANCER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> NECROMANCER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> NECROMANCER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> SKELETON_VANGUARD_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> SKELETON_VANGUARD_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> SKELETON_VANGUARD_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> SKELETON_VANGUARD_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> MOUNTAINEER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> MOUNTAINEER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> MOUNTAINEER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> MOUNTAINEER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> WINDCALLER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> WINDCALLER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> WINDCALLER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> WINDCALLER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> GEOMANCER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> GEOMANCER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> GEOMANCER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> GEOMANCER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ILLUSIONER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> ILLUSIONER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> ILLUSIONER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> ILLUSIONER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> VINDICATOR_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> VINDICATOR_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> VINDICATOR_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> VINDICATOR_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> EVOKER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> EVOKER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> EVOKER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> EVOKER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> PILLAGER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> PILLAGER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> PILLAGER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> PILLAGER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> ROYAL_GUARD_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> ROYAL_GUARD_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> ROYAL_GUARD_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> WHISPERER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> WHISPERER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> WHISPERER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> WHISPERER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> LEAPLEAF_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> LEAPLEAF_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> LEAPLEAF_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> LEAPLEAF_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> SQUALL_GOLEM_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> QUICK_GROWING_VINE_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> QUICK_GROWING_VINE_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> QUICK_GROWING_VINE_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> QUICK_GROWING_VINE_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> POISON_QUILL_VINE_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> POISON_QUILL_VINE_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> POISON_QUILL_VINE_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> POISON_QUILL_VINE_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> FUNGUS_THROWER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> FUNGUS_THROWER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> FUNGUS_THROWER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> FUNGUS_THROWER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ZOMBIFIED_FUNGUS_THROWER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> ZOMBIFIED_FUNGUS_THROWER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> ZOMBIFIED_FUNGUS_THROWER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> ZOMBIFIED_FUNGUS_THROWER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> WITHER_SKELETON_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> WITHER_SKELETON_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> WITHER_SKELETON_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> WITHER_SKELETON_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> SUNKEN_SKELETON_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> SUNKEN_SKELETON_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> SUNKEN_SKELETON_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> SUNKEN_SKELETON_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> DROWNED_NECROMANCER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> DROWNED_NECROMANCER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> DROWNED_NECROMANCER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> DROWNED_NECROMANCER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> WAVEWHISPERER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> WAVEWHISPERER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> WAVEWHISPERER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> WAVEWHISPERER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> QUICK_GROWING_ANEMONE_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> QUICK_GROWING_ANEMONE_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> QUICK_GROWING_ANEMONE_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> QUICK_GROWING_ANEMONE_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> POISON_ANEMONE_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> POISON_ANEMONE_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> POISON_ANEMONE_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> POISON_ANEMONE_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ENDERLING_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> ENDERLING_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> ENDERLING_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> ENDERLING_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ENDERSENT_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> ENDERSENT_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> ENDERSENT_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> ENDERSENT_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> WILDFIRE_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> WILDFIRE_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> WILDFIRE_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_OUTPOST_VANILLA_VINDICATOR;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_OUTPOST_VANILLA_EVOKER;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_OUTPOST_DUNGEONS_MOBS_MELEE;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_OUTPOST_DUNGEONS_MOBS_CASTER;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_MANSION_VANILLA;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_MANSION_DUNGEONS_MOBS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_BASTION_VANILLA;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_BASTION_DUNGEONS_MOBS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_NETHER_FORTRESS_DUNGEONS_MOBS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_DESERT_PYRAMID_DUNGEONS_MOBS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_JUNGLE_TEMPLE_DUNGEONS_MOBS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_BIOME_SPECIFIC_RAIDERS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_MOUNTAINEERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ARMORED_MOUNTAINEERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ROYAL_GUARDS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_GEOMANCERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ILLUSIONERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_MAGES_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ICEOLOGERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_WINDCALLERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ARMORED_PILLAGERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_SQUALL_GOLEMS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_REDSTONE_GOLEMS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_STRONGER_HUSKS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_RANGED_SPIDERS;
        public static ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ITEM_TAB;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Mob Configuration").push("mob_configuration");
            this.ENABLE_WRAITH_FIRE_SUMMON = builder.comment("Enable the default ability of Wraiths to summon Wraith Fire around the player as an attack. \nIf you prefer a less griefy attack using Soul Fireballs akin to the Blaze, disable this feature. [true / false]").define("enableWraithFireSummon", true);
            this.ENABLE_ICY_CREEPER_GRIEFING = builder.comment("Enable the default ability of Icy Creeper Explosions to grief the environment. \nIf you prefer their explosions to not damage the environment, disable this feature. [true / false]").define("enablyIcyCreeperGriefing", true);
            this.ENABLE_MOB_ARMOR_DROPS = builder.comment("Enable mobs to drop their armor when killed. \nIf you prefer mobs to not drop their armor, disable this feature. [true / false]").define("enableMobArmorDrops", true);
            NECROMANCER_MOB_SUMMONS = builder.comment("Add mobs (preferably undead) that the Necromancer can summon. \nTo do so, enter the namespace ID of the mob, like \"minecraft:zombie\".\nIf this list is empty, zombies will be summoned instead.\nIf a mob chosen from this list cannot be spawned, a zombie will be summoned instead.").defineList("necromancerMobSummons", (List)Lists.newArrayList((Object[])new String[]{"minecraft:zombie", "minecraft:skeleton"}), itemRaw -> itemRaw instanceof String);
            DROWNED_NECROMANCER_MOB_SUMMONS = builder.comment("Add mobs (preferably undead and aquatic) that the Drowned Necromancer can summon. \nTo do so, enter the namespace ID of the mob, like \"minecraft:drowned\".\nIf this list is empty, drowned will be summoned instead.\nIf a mob chosen from this list cannot be spawned, a drowned will be summoned instead.").defineList("drownedNecromancerMobSummons", (List)Lists.newArrayList((Object[])new String[]{"minecraft:drowned", "dungeons_mobs:sunken_skeleton"}), itemRaw -> itemRaw instanceof String);
            builder.pop();
            builder.comment("Texture Configuration").push("texture_configuration");
            this.ENABLE_3D_SLEEVES = builder.comment("Enable 3D sleeves on the various Illagers. \nCan be combined with the  resource pack to \nIf you prefer a more vanilla look, disable this feature. [true / false]").define("enable3DSleeves", true);
            builder.pop();
            builder.comment("Spawn Configuration").push("spawn_configuration");
            this.ENABLE_FROZEN_ZOMBIE_REPLACES_ZOMBIE = builder.comment("Enable Frozen Zombies replacing 80% of  Zombie spawns in ICY biomes. \nIf you prefer to not have them do this, disable this feature. [true / false]").define("enableFrozenZombieReplacesZombie", true);
            this.ENABLE_ICY_CREEPER_REPLACES_CREEPER = builder.comment("Enable Icy Creepers replacing 80% of Creeper spawns in ICY biomes. \nIf you prefer to not have them do this, disable this feature. [true / false]").define("enableIcyCreeperReplacesCreeper", true);
            this.ENABLE_JUNGLE_ZOMBIE_REPLACES_ZOMBIE = builder.comment("Enable Jungle Zombies replacing 80% of Zombie spawns in JUNGLE biomes. \nIf you prefer to not have them do this, disable this feature. [true / false]").define("enableJungleZombieReplacesZombie", true);
            this.ENABLE_MOSSY_SKELETON_REPLACES_SKELETON = builder.comment("Enable Mossy Skeletons  80% of Skeleton spawns in JUNGLE biomes. \nIf you prefer to not have them do this, disable this feature. [true / false]").define("enableMossySkeletonReplacesSkeleton", true);
            this.ICEOLOGER_BIOME_TYPES = builder.comment("Add biome types that the Iceologer can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("iceologerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SNOWY", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.ICEOLOGER_SPAWN_WEIGHT = builder.comment("Spawn weight of Iceologers in the locations they can spawn in. [default:5]").defineInRange("iceologerSpawnWeight", 5, 0, 1024);
            this.ICEOLOGER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Iceologers in the locations they can spawn in. [default:1]").defineInRange("iceologerMinGroupSize", 1, 0, 128);
            this.ICEOLOGER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Iceologers in the locations they can spawn in. [default:1]").defineInRange("iceologerMaxGroupSize", 1, 0, 128);
            this.WRAITH_BIOME_TYPES = builder.comment("Add biome types that the Wraith can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("wraithBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"OVERWORLD", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.WRAITH_SPAWN_WEIGHT = builder.comment("Spawn weight of Wraiths in the locations they can spawn in. [default:5]").defineInRange("wraithSpawnWeight", 5, 0, 1024);
            this.WRAITH_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Wraiths in the locations they can spawn in. [default:1]").defineInRange("wraithMinGroupSize", 1, 0, 128);
            this.WRAITH_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Wraiths in the locations they can spawn in. [default:1]").defineInRange("wraithMaxGroupSize", 1, 0, 128);
            this.NECROMANCER_BIOME_TYPES = builder.comment("Add biome types that the Necromancer can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("necromancerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SANDY", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.NECROMANCER_SPAWN_WEIGHT = builder.comment("Spawn weight of Necromancers in the locations they can spawn in. [default:5]").defineInRange("necromancerSpawnWeight", 5, 0, 1024);
            this.NECROMANCER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Necromancers in the locations they can spawn in. [default:1]").defineInRange("necromancerMinGroupSize", 1, 0, 128);
            this.NECROMANCER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Necromancers in the locations they can spawn in. [default:1]").defineInRange("necromancerMaxGroupSize", 1, 0, 128);
            this.SKELETON_VANGUARD_BIOME_TYPES = builder.comment("Add biome types that the Skeleton Vanguard can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("skeletonVanguardBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"OVERWORLD", "DESERT", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.SKELETON_VANGUARD_SPAWN_WEIGHT = builder.comment("Spawn weight of Skeleton Vanguard in the locations they can spawn in. [default:1]").defineInRange("skeletonVanguardSpawnWeight", 1, 0, 1024);
            this.SKELETON_VANGUARD_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Skeleton Vanguard in the locations they can spawn in. [default:1]").defineInRange("skeletonVanguardMinGroupSize", 1, 0, 32);
            this.SKELETON_VANGUARD_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Skeleton Vanguard in the locations they can spawn in. [default:1]").defineInRange("skeletonVanguardMaxGroupSize", 1, 0, 32);
            this.MOUNTAINEER_BIOME_TYPES = builder.comment("Add biome types that the Mountaineer can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("mountaineerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"MOUNTAIN", "!SANDY", "!JUNGLE", "!FOREST", "!MUSHROOM", "!HOT", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.MOUNTAINEER_SPAWN_WEIGHT = builder.comment("Spawn weight of Mountaineers in the locations they can spawn in. [default:5]").defineInRange("mountaineerSpawnWeight", 5, 0, 1024);
            this.MOUNTAINEER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Mountaineers in the locations they can spawn in. [default:1]").defineInRange("mountaineerMinGroupSize", 1, 0, 32);
            this.MOUNTAINEER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Mountaineers in the locations they can spawn in. [default:1]").defineInRange("mountaineerMaxGroupSize", 2, 0, 32);
            this.WINDCALLER_BIOME_TYPES = builder.comment("Add biome types that the Windcaller can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("windcallerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"MOUNTAIN", "!SANDY", "!JUNGLE", "!FOREST", "!MUSHROOM", "!HOT", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.WINDCALLER_SPAWN_WEIGHT = builder.comment("Spawn weight of Windcallers in the locations they can spawn in. [default:5]").defineInRange("windcallerSpawnWeight", 5, 0, 1024);
            this.WINDCALLER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Windcallers in the locations they can spawn in. [default:1]").defineInRange("windcallerMinGroupSize", 1, 0, 128);
            this.WINDCALLER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Windcallers in the locations they can spawn in. [default:1]").defineInRange("windcallerMaxGroupSize", 1, 0, 128);
            this.GEOMANCER_BIOME_TYPES = builder.comment("Add biome types that the Geomancer can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("geomancerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SAVANNA", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.GEOMANCER_SPAWN_WEIGHT = builder.comment("Spawn weight of Geomancers in the locations they can spawn in. [default:5]").defineInRange("geomancerSpawnWeight", 5, 0, 1024);
            this.GEOMANCER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Geomancers in the locations they can spawn in. [default:1]").defineInRange("geomancerMinGroupSize", 1, 0, 128);
            this.GEOMANCER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Geomancers in the locations they can spawn in. [default:1]").defineInRange("geomancerMaxGroupSize", 1, 0, 128);
            this.ILLUSIONER_BIOME_TYPES = builder.comment("Add biome types that the Illusioner can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("illusionerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SNOWY", "MOUNTAIN", "!SANDY", "!JUNGLE", "!FOREST", "!HOT", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.ILLUSIONER_SPAWN_WEIGHT = builder.comment("Spawn weight of Illusioners in the locations they can spawn in. [default:1]").defineInRange("illusionerSpawnWeight", 1, 0, 1024);
            this.ILLUSIONER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Illusioners in the locations they can spawn in. [default:1]").defineInRange("illusionerMinGroupSize", 1, 0, 128);
            this.ILLUSIONER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Illusioners in the locations they can spawn in. [default:1]").defineInRange("illusionerMaxGroupSize", 1, 0, 128);
            this.VINDICATOR_BIOME_TYPES = builder.comment("Add biome types that the Vindicator can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("vindicatorBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SPOOKY", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.VINDICATOR_SPAWN_WEIGHT = builder.comment("Spawn weight of Vindicators in the locations they can spawn in. [default:5]").defineInRange("vindicatorSpawnWeight", 5, 0, 1024);
            this.VINDICATOR_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Vindicators in the locations they can spawn in. [default:1]").defineInRange("vindicatorMinGroupSize", 1, 0, 128);
            this.VINDICATOR_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Vindicators in the locations they can spawn in. [default:1]").defineInRange("vindicatorMaxGroupSize", 2, 0, 128);
            this.EVOKER_BIOME_TYPES = builder.comment("Add biome types that the Evoker can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("evokerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SPOOKY", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.EVOKER_SPAWN_WEIGHT = builder.comment("Spawn weight of Evokers in the locations they can spawn in. [default:1]").defineInRange("evokerSpawnWeight", 1, 0, 1024);
            this.EVOKER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Evokers in the locations they can spawn in. [default:1]").defineInRange("evokerMinGroupSize", 1, 0, 128);
            this.EVOKER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Evokers in the locations they can spawn in. [default:1]").defineInRange("evokerMaxGroupSize", 1, 0, 128);
            this.PILLAGER_BIOME_TYPES = builder.comment("Add biome types that the Pillager can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("pillagerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SPOOKY", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.PILLAGER_SPAWN_WEIGHT = builder.comment("Spawn weight of Pillagers in the locations they can spawn in. [default:5]").defineInRange("pillagerSpawnWeight", 5, 0, 1024);
            this.PILLAGER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Pillagers in the locations they can spawn in. [default:1]").defineInRange("pillagerMinGroupSize", 1, 0, 128);
            this.PILLAGER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Pillagers in the locations they can spawn in. [default:1]").defineInRange("pillagerMaxGroupSize", 3, 0, 128);
            this.ROYAL_GUARD_SPAWN_WEIGHT = builder.comment("Spawn weight of Royal Guards in the locations they can spawn in. [default:10]").defineInRange("royalGuardSpawnWeight", 10, 0, 1024);
            this.ROYAL_GUARD_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Royal Guards in the locations they can spawn in. [default:1]").defineInRange("royalGuardMinGroupSize", 1, 0, 128);
            this.ROYAL_GUARD_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Royal Guards in the locations they can spawn in. [default:1]").defineInRange("royalGuardMaxGroupSize", 2, 0, 128);
            this.WHISPERER_BIOME_TYPES = builder.comment("Add biome types that the Whisperer can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("whispererBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"JUNGLE", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.WHISPERER_SPAWN_WEIGHT = builder.comment("Spawn weight of Whisperers in the locations they can spawn in. [default:5]").defineInRange("whispererSpawnWeight", 5, 0, 1024);
            this.WHISPERER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Whisperers in the locations they can spawn in. [default:1]").defineInRange("whispererMinGroupSize", 1, 0, 128);
            this.WHISPERER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Whisperers in the locations they can spawn in. [default:4]").defineInRange("whispererMaxGroupSize", 1, 0, 128);
            this.LEAPLEAF_BIOME_TYPES = builder.comment("Add biome types that the Leapleaf can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("leapleafBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"JUNGLE", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.LEAPLEAF_SPAWN_WEIGHT = builder.comment("Spawn weight of Leapleafs in the locations they can spawn in. [default:5]").defineInRange("leapleafSpawnWeight", 5, 0, 1024);
            this.LEAPLEAF_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Leapleafs in the locations they can spawn in. [default:1]").defineInRange("leapleafMinGroupSize", 1, 0, 128);
            this.LEAPLEAF_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Leapleafs in the locations they can spawn in. [default:4]").defineInRange("leapleafMaxGroupSize", 4, 0, 128);
            this.QUICK_GROWING_VINE_BIOME_TYPES = builder.comment("Add biome types that the Quick-Growing Vines can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("quickGrowingVineBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"JUNGLE", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.QUICK_GROWING_VINE_SPAWN_WEIGHT = builder.comment("Spawn weight of Quick-Growing Vines in the locations they can spawn in. [default:5]").defineInRange("quickGrowingVineSpawnWeight", 5, 0, 1024);
            this.QUICK_GROWING_VINE_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Quick-Growing Vines in the locations they can spawn in. [default:1]").defineInRange("quickGrowingVineMinGroupSize", 1, 0, 128);
            this.QUICK_GROWING_VINE_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Quick-Growing Vines in the locations they can spawn in. [default:1]").defineInRange("quickGrowingVineMaxGroupSize", 1, 0, 128);
            this.POISON_QUILL_VINE_BIOME_TYPES = builder.comment("Add biome types that the Poison-Quill Vines can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("poisonQuillVineBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"JUNGLE", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.POISON_QUILL_VINE_SPAWN_WEIGHT = builder.comment("Spawn weight of Poison-Quill Vines in the locations they can spawn in. [default:5]").defineInRange("poisonQuillVineSpawnWeight", 5, 0, 1024);
            this.POISON_QUILL_VINE_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Poison-Quill Vines in the locations they can spawn in. [default:1]").defineInRange("poisonQuillVineMinGroupSize", 1, 0, 128);
            this.POISON_QUILL_VINE_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Poison-Quill Vines in the locations they can spawn in. [default:1]").defineInRange("poisonQuillVineMaxGroupSize", 1, 0, 128);
            this.FUNGUS_THROWER_BIOME_TYPES = builder.comment("Add biome types that the Fungus Thrower can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("fungusThrowerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"NETHER", "CRIMSON", "!WARPED", "!SOULSAND", "!DELTA", "!OVERWORLD", "!END"}), itemRaw -> itemRaw instanceof String);
            this.FUNGUS_THROWER_SPAWN_WEIGHT = builder.comment("Spawn weight of Fungus Throwers in the locations they can spawn in. [default:5]").defineInRange("fungusThrowerSpawnWeight", 5, 0, 1024);
            this.FUNGUS_THROWER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Fungus Throwers in the locations they can spawn in. [default:3]").defineInRange("fungusThrowerMinGroupSize", 3, 0, 128);
            this.FUNGUS_THROWER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Fungus Throwers in the locations they can spawn in. [default:4]").defineInRange("fungusThrowerMaxGroupSize", 4, 0, 128);
            this.ZOMBIFIED_FUNGUS_THROWER_BIOME_TYPES = builder.comment("Add biome types that the Zombified Fungus Thrower can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("zombifiedFungusThrowerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"NETHER", "CRIMSON", "!WARPED", "!SOULSAND", "!DELTA", "!OVERWORLD", "!END"}), itemRaw -> itemRaw instanceof String);
            this.ZOMBIFIED_FUNGUS_THROWER_SPAWN_WEIGHT = builder.comment("Spawn weight of Zombified Fungus Throwers in the locations they can spawn in. [default:5]").defineInRange("zombifiedFungusThrowerSpawnWeight", 5, 0, 1024);
            this.ZOMBIFIED_FUNGUS_THROWER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Zombified Fungus Throwers in the locations they can spawn in. [default:3]").defineInRange("zombifiedFungusThrowerMinGroupSize", 3, 0, 128);
            this.ZOMBIFIED_FUNGUS_THROWER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Zombified Fungus Throwers in the locations they can spawn in. [default:4]").defineInRange("zombifiedFungusThrowerMaxGroupSize", 4, 0, 128);
            this.WITHER_SKELETON_BIOME_TYPES = builder.comment("Add biome types that the Wither Skeleton can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("witherSkeletonBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"NETHER", "SOULSAND", "!CRIMSON", "!WARPED", "!DELTA", "!OVERWORLD", "!END"}), itemRaw -> itemRaw instanceof String);
            this.WITHER_SKELETON_SPAWN_WEIGHT = builder.comment("Spawn weight of Wither Skeletons in the locations they can spawn in. [default:5]").defineInRange("witherSkeletonSpawnWeight", 5, 0, 1024);
            this.WITHER_SKELETON_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Wither Skeletons in the locations they can spawn in. [default:1]").defineInRange("witherSkeletonMinGroupSize", 1, 0, 128);
            this.WITHER_SKELETON_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Wither Skeletons in the locations they can spawn in. [default:4]").defineInRange("witherSkeletonMaxGroupSize", 4, 0, 128);
            this.SUNKEN_SKELETON_BIOME_TYPES = builder.comment("Add biome types that the Sunken Skeleton can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("sunkenSkeletonBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"WATER", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.SUNKEN_SKELETON_SPAWN_WEIGHT = builder.comment("Spawn weight of Sunken Skeletons in the locations they can spawn in. [default:5]").defineInRange("sunkenSkeletonSpawnWeight", 5, 0, 1024);
            this.SUNKEN_SKELETON_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Sunken Skeletons in the locations they can spawn in. [default:1]").defineInRange("sunkenSkeletonMinGroupSize", 1, 0, 128);
            this.SUNKEN_SKELETON_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Sunken Skeletons in the locations they can spawn in. [default:4]").defineInRange("sunkenSkeletonMaxGroupSize", 1, 0, 128);
            this.DROWNED_NECROMANCER_BIOME_TYPES = builder.comment("Add biome types that the Drowned Necromancer can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("drownedNecromancerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"OCEAN", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.DROWNED_NECROMANCER_SPAWN_WEIGHT = builder.comment("Spawn weight of Drowned Necromancers in the locations they can spawn in. [default:5]").defineInRange("drownedNecromancerSpawnWeight", 5, 0, 1024);
            this.DROWNED_NECROMANCER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Drowned Necromancers in the locations they can spawn in. [default:1]").defineInRange("drownedNecromancerMinGroupSize", 1, 0, 128);
            this.DROWNED_NECROMANCER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Drowned Necromancers in the locations they can spawn in. [default:4]").defineInRange("drownedNecromancerMaxGroupSize", 1, 0, 128);
            this.WAVEWHISPERER_BIOME_TYPES = builder.comment("Add biome types that the Wavehisperer can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("wavewhispererBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"OCEAN", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.WAVEWHISPERER_SPAWN_WEIGHT = builder.comment("Spawn weight of Wavehisperers in the locations they can spawn in. [default:5]").defineInRange("wavewhispererSpawnWeight", 5, 0, 1024);
            this.WAVEWHISPERER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Wavehisperers in the locations they can spawn in. [default:1]").defineInRange("wavewhispererMinGroupSize", 1, 0, 128);
            this.WAVEWHISPERER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Wavehisperers in the locations they can spawn in. [default:4]").defineInRange("wavewhispererMaxGroupSize", 1, 0, 128);
            this.QUICK_GROWING_ANEMONE_BIOME_TYPES = builder.comment("Add biome types that the Quick-Growing Anemone can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("quickGrowingAnemoneBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"OCEAN", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.QUICK_GROWING_ANEMONE_SPAWN_WEIGHT = builder.comment("Spawn weight of Quick-Growing Anemone in the locations they can spawn in. [default:5]").defineInRange("quickGrowingAnemoneSpawnWeight", 5, 0, 1024);
            this.QUICK_GROWING_ANEMONE_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Quick-Growing Anemone in the locations they can spawn in. [default:1]").defineInRange("quickGrowingAnemoneMinGroupSize", 1, 0, 128);
            this.QUICK_GROWING_ANEMONE_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Quick-Growing Anemone in the locations they can spawn in. [default:1]").defineInRange("quickGrowingAnemoneMaxGroupSize", 1, 0, 128);
            this.POISON_ANEMONE_BIOME_TYPES = builder.comment("Add biome types that the Poison Anemone can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("poisonAnemoneBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"OCEAN", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.POISON_ANEMONE_SPAWN_WEIGHT = builder.comment("Spawn weight of Poison Anemone in the locations they can spawn in. [default:5]").defineInRange("poisonAnemoneSpawnWeight", 5, 0, 1024);
            this.POISON_ANEMONE_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Poison Anemone in the locations they can spawn in. [default:1]").defineInRange("poisonAnemoneMinGroupSize", 1, 0, 128);
            this.POISON_ANEMONE_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Poison Anemone in the locations they can spawn in. [default:1]").defineInRange("poisonAnemoneMaxGroupSize", 1, 0, 128);
            this.ENDERLING_BIOME_TYPES = builder.comment("Add biome types that the Enderlings can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("enderlingBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"END", "!END_CENTER"}), itemRaw -> itemRaw instanceof String);
            this.ENDERLING_SPAWN_WEIGHT = builder.comment("Spawn weight of Enderlings in the locations they can spawn in. [default:5]").defineInRange("enderlingSpawnWeight", 5, 0, 1024);
            this.ENDERLING_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Enderlings in the locations they can spawn in. [default:1]").defineInRange("enderlingMinGroupSize", 1, 0, 128);
            this.ENDERLING_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Enderlings in the locations they can spawn in. [default:3]").defineInRange("enderlingMaxGroupSize", 3, 0, 128);
            this.ENDERSENT_BIOME_TYPES = builder.comment("Add biome types that the Enderlings can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("enderlingBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"END", "!END_CENTER"}), itemRaw -> itemRaw instanceof String);
            this.ENDERSENT_SPAWN_WEIGHT = builder.comment("Spawn weight of Endersents in the locations they can spawn in. [default:1]").defineInRange("endersentSpawnWeight", 1, 0, 1024);
            this.ENDERSENT_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Endersents in the locations they can spawn in. [default:1]").defineInRange("endersentMinGroupSize", 1, 0, 128);
            this.ENDERSENT_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Endersents in the locations they can spawn in. [default:1]").defineInRange("endersentMaxGroupSize", 1, 0, 128);
            this.WILDFIRE_SPAWN_WEIGHT = builder.comment("Spawn weight of wildfires in the locations they can spawn in. [default:1]").defineInRange("wildfireSpawnWeight", 1, 0, 1024);
            this.WILDFIRE_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Wildfires in the locations they can spawn in. [default:1]").defineInRange("wildfireMinGroupSize", 1, 0, 128);
            this.WILDFIRE_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Wildfires in the locations they can spawn in. [default:1]").defineInRange("wildfireMaxGroupSize", 1, 0, 128);
            builder.pop();
            builder.comment("Structure Spawn Configuration").push("structure_spawn_configuration");
            this.ENABLE_OUTPOST_VANILLA_VINDICATOR = builder.comment("Enables logic for allowing vindicators to spawn in Outposts. Defaults to true [true / false]").define("enableOutpostVanillaVindicator", true);
            this.ENABLE_OUTPOST_VANILLA_EVOKER = builder.comment("Enables logic for allowing evokers to spawn in Outposts. Defaults to false [true / false]").define("enableOutpostVanillaEvoker", false);
            this.ENABLE_OUTPOST_DUNGEONS_MOBS_MELEE = builder.comment("Enables logic for allowing melee Dungeons Mobs to spawn in Outposts. Defaults to true [true / false]").define("enableOutpostDungeonsMobsMelee", true);
            this.ENABLE_OUTPOST_DUNGEONS_MOBS_CASTER = builder.comment("Enables logic for allowing caster Dungeons Mobs to spawn in Outposts. Defaults to false [true / false]").define("enableOutpostDungeonsMobsCaster", false);
            this.ENABLE_MANSION_VANILLA = builder.comment("Enables logic for allowing vanilla mobs to spawn in Mansions. Defaults to true [true / false]").define("enableMansionVanilla", true);
            this.ENABLE_MANSION_DUNGEONS_MOBS = builder.comment("Enables logic for allowing Dungeons Mobs to spawn in Mansions. Defaults to true [true / false]").define("enableMansionDungeonsMobs", true);
            this.ENABLE_BASTION_VANILLA = builder.comment("Enables logic for allowing vanilla mobs to spawn in Bastions. Defaults to true [true / false]").define("enableBastionVanilla", true);
            this.ENABLE_BASTION_DUNGEONS_MOBS = builder.comment("Enables logic for allowing Dungeons Mobs to spawn in Bastions. Defaults to true [true / false]").define("enableBastionDungeonsMobs", true);
            this.ENABLE_NETHER_FORTRESS_DUNGEONS_MOBS = builder.comment("Enables logic for allowing Dungeons Mobs to spawn in Nether Fortresses. Defaults to true [true / false]").define("enableNetherFortressDungeonsMobs", true);
            this.ENABLE_DESERT_PYRAMID_DUNGEONS_MOBS = builder.comment("Enables logic for allowing Dungeons Mobs to spawn in Desert Pyramids. Defaults to true [true / false]").define("enableDesertPyramidDungeonsMobs", true);
            this.ENABLE_JUNGLE_TEMPLE_DUNGEONS_MOBS = builder.comment("Enables logic for allowing Dungeons Mobs to spawn in Jungle Temples. Defaults to true [true / false]").define("enableJungleTempleDungeonsMobs", true);
            builder.pop();
            builder.comment("Raid Configuration").push("raid_configuration");
            this.ENABLE_BIOME_SPECIFIC_RAIDERS = builder.comment("Enables logic for only allowing certain raiders to spawn as a part of raids in certain biome types.  \nThis will make the Mountaineers, Windcaller, Iceologer and Squall Golem only spawn as raiders in their allowed biomes. \nIf they are not allowed to spawn as part of a raid in a given biome, \nanother equivalent Illager type (Vindicator, Evoker, Ravager) will spawn instead. \nIf they are not configured to be added to raids, \nthey will replace their equivalent Illager type (Vindicator, Evoker, Ravager) in raids taking place in their allowed biomes. [true / false]").define("enableBiomeSpecificRaiders", false);
            this.SQUALL_GOLEM_BIOME_TYPES = builder.comment("Add biome types that the Squall Golem can spawn in (if biome-specific raiding is enabled). \nPut a \"!\" before the type to prevent spawning (in biome-specific raids) in that biome type. \nLeave this blank if you don't want them to spawn (in biome-specific raids) at all.").defineList("squallGolemBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"MOUNTAIN", "!SANDY", "!JUNGLE", "!FOREST", "!MUSHROOM", "!HOT", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.ENABLE_MOUNTAINEERS_IN_RAIDS = builder.comment("Enable the addition of Mountaineers to raids. [true / false]").define("enableMountaineersInRaids", false);
            this.ENABLE_ARMORED_MOUNTAINEERS_IN_RAIDS = builder.comment("Enable the addition of Armored Mountaineers to raids. [true / false]").define("enableArmoredMountaineersInRaids", false);
            this.ENABLE_ROYAL_GUARDS_IN_RAIDS = builder.comment("Enable the addition of Royal Guards to raids. [true / false]").define("enableRoyalGuardsInRaids", false);
            this.ENABLE_GEOMANCERS_IN_RAIDS = builder.comment("Enable the addition of Geomancers to raids. [true / false]").define("enableGeomancersInRaids", true);
            this.ENABLE_ILLUSIONERS_IN_RAIDS = builder.comment("Enable the addition of Illusioners to raids. [true / false]").define("enableIllusionersInRaids", false);
            this.ENABLE_MAGES_IN_RAIDS = builder.comment("Enable the addition of Mages to raids. [true / false]").define("enableMagesInRaids", false);
            this.ENABLE_ICEOLOGERS_IN_RAIDS = builder.comment("Enable the addition of Iceologers to raids. [true / false]").define("enableIceologersInRaids", false);
            this.ENABLE_WINDCALLERS_IN_RAIDS = builder.comment("Enable the addition of Windcallers to raids. [true / false]").define("enableWindcallersInRaids", false);
            this.ENABLE_ARMORED_PILLAGERS_IN_RAIDS = builder.comment("Enable the addition of Armored Pillagers to raids. [true / false]").define("enableArmoredPillagersInRaids", true);
            this.ENABLE_SQUALL_GOLEMS_IN_RAIDS = builder.comment("Enable the addition of Squall Golems to raids. [true / false]").define("enableSquallGolemsInRaids", true);
            this.ENABLE_REDSTONE_GOLEMS_IN_RAIDS = builder.comment("Enable the addition of Redstone Golems to raids. [true / false]").define("enableRedstoneGolemsInRaids", true);
            builder.pop();
            builder.comment("Vanilla Mob Configuration").push("vanilla_mob_configuration");
            this.ENABLE_STRONGER_HUSKS = builder.comment("Enable the addition of additional attributes to Husks to make them as powerful as they are in Minecraft Dungeons. [true / false]").define("enableStrongerHusks", true);
            this.ENABLE_RANGED_SPIDERS = builder.comment("Enables Spiders and Cave Spiders shooting webs as a ranged attack like they do in Minecraft Dungeons. [true / false]").define("enableRangedSpiders", true);
            builder.pop();
            builder.comment("Mob Items Configuration").push("mob_items_configuration");
            ENABLE_ITEM_TAB = builder.comment("Enable armors appearing in their own tab in the creative menu. \nDisabling this feature will hide them from creative tab. [true / false]").define("enableItemTab", true);
            builder.pop();
        }
    }
}

