/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.capability.MobEnchantCapability;
import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.registry.MobEnchants;
import com.infamous.dungeons_libraries.utils.AreaOfEffectHelper;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.network.datasync.ModDataSerializers;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class EnchanterEntity
extends SpellcasterIllager
implements IAnimatable {
    public static final EntityDataAccessor<Integer> ATTACK_TICKS = SynchedEntityData.m_135353_(EnchanterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ENCHANT_TICKS = SynchedEntityData.m_135353_(EnchanterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<List<UUID>> ENCHANTMENT_TARGETS = SynchedEntityData.m_135353_(EnchanterEntity.class, ModDataSerializers.UUID_LIST);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private Monster enchantmentTarget;
    private List<Monster> enchantmentTargets = new ArrayList<Monster>();

    public EnchanterEntity(Level world) {
        super((EntityType)ModEntityTypes.GEOMANCER.get(), world);
    }

    public EnchanterEntity(EntityType<? extends SpellcasterIllager> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22276_, 14.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_TICKS, (Object)0);
        this.f_19804_.m_135372_(ENCHANT_TICKS, (Object)0);
        this.f_19804_.m_135372_(ENCHANTMENT_TARGETS, new ArrayList());
    }

    public int getAttackTicks() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TICKS);
    }

    public void setAttackTicks(int p_189794_1_) {
        this.f_19804_.m_135381_(ATTACK_TICKS, (Object)p_189794_1_);
    }

    public int getEnchantTicks() {
        return (Integer)this.f_19804_.m_135370_(ENCHANT_TICKS);
    }

    public void setEnchantTicks(int p_189794_1_) {
        this.f_19804_.m_135381_(ENCHANT_TICKS, (Object)p_189794_1_);
    }

    public void addEnchantmentTarget(Monster monsterEntity) {
        this.enchantmentTargets.add(monsterEntity);
        this.f_19804_.m_135381_(ENCHANTMENT_TARGETS, this.enchantmentTargets.stream().map(Entity::m_142081_).collect(Collectors.toList()));
    }

    public void setEnchantmentTargets(List<Monster> monsterEntities) {
        this.enchantmentTargets = monsterEntities;
        this.f_19804_.m_135381_(ENCHANTMENT_TARGETS, this.enchantmentTargets.stream().map(Entity::m_142081_).collect(Collectors.toList()));
    }

    public boolean m_7490_() {
        return false;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AttackingGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new CastingSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new EnchantSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    @Nullable
    private Monster getEnchantmentTarget() {
        return this.enchantmentTarget;
    }

    private void setEnchantmentTarget(@Nullable Monster p_190748_1_) {
        this.enchantmentTarget = p_190748_1_;
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.f_19853_.m_45930_((Entity)this, 2.0) != null && this.m_5448_() != null && this.f_19853_.m_45930_((Entity)this, 2.0) == this.m_5448_()) {
            if (this.getAttackTicks() == 0 && this.f_19796_.nextInt(10) == 0) {
                this.setAttackTicks(40);
                this.m_5496_((SoundEvent)ModSoundEvents.ENCHANTER_PRE_ATTACK.get(), this.m_6121_(), this.m_6100_());
            } else if (this.getAttackTicks() == 12) {
                this.m_7327_((Entity)this.f_19853_.m_45930_((Entity)this, 2.0));
                this.m_5496_((SoundEvent)ModSoundEvents.ENCHANTER_ATTACK.get(), this.m_6121_(), this.m_6100_());
            }
        }
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        if (this.getEnchantTicks() > 0) {
            this.setEnchantTicks(this.getEnchantTicks() - 1);
        }
        List<Monster> validEnchantmentTargets = this.enchantmentTargets.stream().filter(this::isValidEnchantmentTarget).collect(Collectors.toList());
        this.enchantmentTargets.stream().filter(monsterEntity -> !validEnchantmentTargets.contains(monsterEntity)).filter(LivingEntity::m_6084_).forEach(this::clearEntityMobEnchantments);
        this.setEnchantmentTargets(validEnchantmentTargets);
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
        this.enchantmentTargets.forEach(this::clearEntityMobEnchantments);
        this.setEnchantmentTargets(new ArrayList<Monster>());
    }

    private void clearEntityMobEnchantments(Monster entity) {
        entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(enchantableCapability -> {
            enchantableCapability.removeAllMobEnchant((LivingEntity)entity);
            entity.m_6210_();
        });
    }

    private boolean isValidEnchantmentTarget(Monster monsterEntity) {
        return monsterEntity.m_6084_() && monsterEntity.m_20270_((Entity)this) <= 30.0f;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getEnchantTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("enchanter_enchant", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.getAttackTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("enchanter_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("enchanter_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("enchanter_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.ENCHANTER_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.ENCHANTER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENCHANTER_HURT.get();
    }

    protected SoundEvent m_7894_() {
        return (SoundEvent)ModSoundEvents.ENCHANTER_BEAM.get();
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSoundEvents.ENCHANTER_IDLE.get();
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        AbstractIllager.IllagerArmPose illagerArmPose = super.m_6768_();
        if (illagerArmPose == AbstractIllager.IllagerArmPose.CROSSED) {
            return AbstractIllager.IllagerArmPose.NEUTRAL;
        }
        return illagerArmPose;
    }

    class AttackingGoal
    extends Goal {
        public AttackingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return EnchanterEntity.this.getAttackTicks() > 0 && EnchanterEntity.this.m_5448_() != null;
        }

        public void m_8037_() {
            EnchanterEntity.this.m_21573_().m_26573_();
            EnchanterEntity.this.m_21563_().m_24946_(EnchanterEntity.this.m_5448_().m_20185_(), EnchanterEntity.this.m_5448_().m_20188_(), EnchanterEntity.this.m_5448_().m_20189_());
        }
    }

    class CastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        private CastingSpellGoal() {
            super((SpellcasterIllager)EnchanterEntity.this);
        }

        public void m_8037_() {
            if (EnchanterEntity.this.getEnchantmentTarget() != null) {
                EnchanterEntity.this.m_21563_().m_24960_((Entity)EnchanterEntity.this.getEnchantmentTarget(), (float)EnchanterEntity.this.m_8085_(), (float)EnchanterEntity.this.m_8132_());
            }
        }
    }

    public class EnchantSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public EnchantSpellGoal() {
            super((SpellcasterIllager)EnchanterEntity.this);
        }

        public boolean m_8036_() {
            if (EnchanterEntity.this.m_5448_() == null) {
                return false;
            }
            if (EnchanterEntity.this.m_33736_()) {
                return false;
            }
            if (EnchanterEntity.this.f_19797_ < this.f_33775_) {
                return false;
            }
            if (EnchanterEntity.this.enchantmentTargets.size() > 1) {
                return false;
            }
            List list = AreaOfEffectHelper.getNearbyEnemies((Entity)EnchanterEntity.this, (float)16.0f, (Level)EnchanterEntity.this.f_19853_, livingEntity -> {
                if (livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).isPresent()) {
                    MobEnchantCapability mobEnchantCapability = (MobEnchantCapability)livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).resolve().get();
                    return !mobEnchantCapability.hasEnchant() && livingEntity instanceof Monster;
                }
                return false;
            });
            if (list.isEmpty()) {
                return false;
            }
            EnchanterEntity.this.setEnchantmentTarget((Monster)list.get(EnchanterEntity.this.f_19796_.nextInt(list.size())));
            EnchanterEntity.this.setEnchantTicks(45);
            return true;
        }

        public boolean m_8045_() {
            return EnchanterEntity.this.getEnchantmentTarget() != null && this.f_33774_ > 0;
        }

        public void m_8041_() {
            super.m_8041_();
            EnchanterEntity.this.setEnchantmentTarget(null);
        }

        protected void m_8130_() {
            Monster selectedMonsterEntity = EnchanterEntity.this.getEnchantmentTarget();
            if (selectedMonsterEntity != null && selectedMonsterEntity.m_6084_()) {
                selectedMonsterEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                    cap.addMobEnchant((LivingEntity)selectedMonsterEntity, (MobEnchant)MobEnchants.STRONG.get(), 2);
                    cap.addMobEnchant((LivingEntity)selectedMonsterEntity, (MobEnchant)MobEnchants.PROTECTION.get(), 2);
                    selectedMonsterEntity.m_6210_();
                });
                EnchanterEntity.this.addEnchantmentTarget(selectedMonsterEntity);
            }
        }

        protected int m_8069_() {
            return 40;
        }

        protected int m_8089_() {
            return 45;
        }

        protected int m_8067_() {
            return 140;
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModSoundEvents.ENCHANTER_SPELL.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.NONE;
        }
    }
}

