/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.entities.summonables.ConstructEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.AvoidBaseEntityGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.GeomancyHelper;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class GeomancerEntity
extends SpellcasterIllager
implements IAnimatable,
SpawnArmoredMob {
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int summonBombsAttackAnimationTick;
    public int summonBombsAttackAnimationLength = 35;
    public int summonBombsAttackAnimationActionPoint = 15;
    public int summonWallsAnimationTick;
    public int summonWallsAnimationLength = 35;
    public int summonWallsAnimationActionPoint = 20;

    public GeomancerEntity(EntityType<? extends SpellcasterIllager> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Evoker.m_32657_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 30.0);
    }

    public boolean m_7490_() {
        return false;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new SummonPillarsGoal(this));
        this.f_21345_.m_25352_(1, new AvoidBaseEntityGoal<ConstructEntity>((PathfinderMob)this, ConstructEntity.class, 5.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractVillager.class, 3.0f, 1.2, 1.15));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 3.0f, 1.2, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 3.0f, 1.3, 1.15));
        this.f_21345_.m_25352_(3, (Goal)new ApproachTargetGoal((PathfinderMob)this, 15.0, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(600));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(600));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false).m_26146_(600));
    }

    public boolean m_21526_() {
        return false;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.summonWallsAnimationTick = this.summonWallsAnimationLength;
        } else if (p_28844_ == 11) {
            this.summonBombsAttackAnimationTick = this.summonBombsAttackAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
    }

    public void tickDownAnimTimers() {
        if (this.summonWallsAnimationTick >= 0) {
            --this.summonWallsAnimationTick;
        }
        if (this.summonBombsAttackAnimationTick >= 0) {
            --this.summonBombsAttackAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.summonBombsAttackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.summonWallsAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_37888_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_celebrate", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_6851_(DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.GEOMANCER_STAFF.get()));
        SpawnArmoredHelper.equipArmorSet(ModItems.GEOMANCER_ARMOR, (Mob)this);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.m_6851_(difficultyIn);
        this.m_6850_(difficultyIn);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public ArmorSet getArmorSet() {
        return ModItems.GEOMANCER_ARMOR;
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.GEOMANCER_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.GEOMANCER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.GEOMANCER_HURT.get();
    }

    protected SoundEvent m_7894_() {
        return (SoundEvent)ModSoundEvents.GEOMANCER_ATTACK.get();
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSoundEvents.GEOMANCER_IDLE.get();
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        AbstractIllager.IllagerArmPose illagerArmPose = super.m_6768_();
        if (illagerArmPose == AbstractIllager.IllagerArmPose.CROSSED) {
            return AbstractIllager.IllagerArmPose.NEUTRAL;
        }
        return illagerArmPose;
    }

    class SummonPillarsGoal
    extends Goal {
        public GeomancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime = 0;

        public SummonPillarsGoal(GeomancerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.f_19797_ >= this.nextUseTime && this.mob.m_20270_((Entity)this.target) <= 20.0f && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && this.animationsNotUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)ModSoundEvents.GEOMANCER_PRE_ATTACK.get(), 1.0f, this.mob.m_6100_());
            if (this.mob.f_19796_.nextBoolean()) {
                this.mob.summonWallsAnimationTick = this.mob.summonWallsAnimationLength;
                this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
            } else {
                this.mob.summonBombsAttackAnimationTick = this.mob.summonBombsAttackAnimationLength;
                this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)11);
            }
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
            }
            if (this.target != null && this.mob.summonWallsAnimationTick == this.mob.summonWallsAnimationActionPoint) {
                this.mob.m_5496_((SoundEvent)ModSoundEvents.GEOMANCER_ATTACK.get(), 1.0f, this.mob.m_6100_());
                int randomInt = this.mob.f_19796_.nextInt(3);
                if (randomInt == 0) {
                    int[] rowToRemove = (int[])Util.m_137545_((Object[])GeomancyHelper.CONFIG_1_ROWS, (Random)this.mob.m_21187_());
                    GeomancyHelper.summonAreaDenialTrap((LivingEntity)this.mob, (Entity)this.target, (EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_WALL.get()), rowToRemove);
                } else if (randomInt == 1) {
                    GeomancyHelper.summonWallTrap((LivingEntity)this.mob, (Entity)this.target, (EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_WALL.get()));
                } else {
                    GeomancyHelper.summonRandomPillarsTrap((LivingEntity)this.mob, (Entity)this.target, (EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_WALL.get()));
                }
            }
            if (this.target != null && this.mob.summonBombsAttackAnimationTick == this.mob.summonBombsAttackAnimationActionPoint) {
                this.mob.m_5496_((SoundEvent)ModSoundEvents.GEOMANCER_ATTACK.get(), 1.0f, this.mob.m_6100_());
                if (this.mob.m_21187_().nextBoolean()) {
                    GeomancyHelper.summonQuadOffensiveTrap((LivingEntity)this.mob, (Entity)this.target, (EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_BOMB.get()));
                } else {
                    boolean movingOnX = this.mob.f_19796_.nextBoolean();
                    GeomancyHelper.summonOffensiveConstruct((LivingEntity)this.mob, (Entity)this.target, (EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_BOMB.get()), movingOnX ? (double)(this.mob.f_19796_.nextBoolean() ? 2 : -2) : 0.0, !movingOnX ? (double)(this.mob.f_19796_.nextBoolean() ? 2 : -2) : 0.0, Direction.NORTH);
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.nextUseTime = this.mob.f_19797_ + 100 + this.mob.f_19796_.nextInt(40);
        }

        public boolean animationsUseable() {
            return this.mob.summonWallsAnimationTick <= 0 || this.mob.summonBombsAttackAnimationTick <= 0;
        }

        public boolean animationsNotUseable() {
            return this.mob.summonWallsAnimationTick > 0 || this.mob.summonBombsAttackAnimationTick > 0;
        }
    }
}

