/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.entities.projectiles.MageMissileEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MageCloneEntity
extends AbstractIllager
implements IAnimatable,
SpawnArmoredMob {
    private static final EntityDataAccessor<Boolean> DELAYED_APPEAR = SynchedEntityData.m_135353_(MageCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int shootAnimationTick;
    public int shootAnimationLength = 40;
    public int shootAnimationActionPoint = 20;
    public int appearAnimationTick;
    public int appearAnimationLength = 25;
    public int lifeTime;
    private Mob owner;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public MageCloneEntity(EntityType<? extends MageCloneEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new RemainStationaryGoal());
        this.f_21345_.m_25352_(1, (Goal)new ShootAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractVillager.class, 5.0f, 1.2, 1.15));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 5.0f, 1.2, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 5.0f, 1.3, 1.15));
        this.f_21345_.m_25352_(3, (Goal)new ApproachTargetGoal((PathfinderMob)this, 14.0, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new CopyOwnerTargetGoal((PathfinderMob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DELAYED_APPEAR, (Object)false);
    }

    public boolean hasDelayedAppear() {
        return (Boolean)this.f_19804_.m_135370_(DELAYED_APPEAR);
    }

    public void setDelayedAppear(boolean attached) {
        this.f_19804_.m_135381_(DELAYED_APPEAR, (Object)attached);
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (p_70097_1_.m_7639_() != null && this.m_7307_(p_70097_1_.m_7639_()) && p_70097_1_ != DamageSource.f_19317_) {
            return false;
        }
        return super.m_6469_(p_70097_1_, p_70097_2_);
    }

    public Mob getOwner() {
        return this.owner;
    }

    public void setOwner(Mob p_190658_1_) {
        this.owner = p_190658_1_;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 1) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.nextGaussian() * 0.02;
                double d1 = this.f_19796_.nextGaussian() * 0.02;
                double d2 = this.f_19796_.nextGaussian() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
            }
        }
    }

    public boolean shouldBeStationary() {
        return this.appearAnimationTick > 0;
    }

    public boolean m_21526_() {
        return false;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22276_, 40.0);
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 8) {
            this.appearAnimationTick = this.appearAnimationLength;
        } else if (p_28844_ == 11) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.nextGaussian() * 0.02;
                double d1 = this.f_19796_.nextGaussian() * 0.02;
                double d2 = this.f_19796_.nextGaussian() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
            }
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        ++this.lifeTime;
        if (!this.f_19853_.f_46443_ && this.hasDelayedAppear()) {
            this.appearAnimationTick = this.appearAnimationLength;
            this.f_19853_.m_7605_((Entity)this, (byte)8);
            this.setDelayedAppear(false);
        }
        int lifeTimeByDifficulty = this.f_19853_.m_6436_(this.m_142538_()).m_19048_().m_19028_();
        if (!this.f_19853_.f_46443_ && (this.f_20916_ > 0 || this.lifeTime >= lifeTimeByDifficulty * 100 || this.getOwner() != null && (this.getOwner().m_21224_() || this.getOwner().f_20916_ > 0 || this.getOwner().m_5448_() == null))) {
            if (this.f_20916_ > 0) {
                this.m_5496_(this.m_5592_(), this.m_6121_(), this.m_6100_());
            } else {
                this.m_5496_(SoundEvents.f_12052_, this.m_6121_(), 1.0f);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            this.f_19853_.m_7605_((Entity)this, (byte)11);
        }
        if (!this.f_19853_.f_46443_ && this.getOwner() != null) {
            this.m_21153_(this.getOwner().m_21223_());
        }
    }

    public void tickDownAnimTimers() {
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
        if (this.appearAnimationTick > 0) {
            --this.appearAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.appearAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mage_appear", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mage_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mage_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_37888_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mage_celebrate", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mage_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12048_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.ENCHANTER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENCHANTER_HURT.get();
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12048_;
    }

    public ArmorSet getArmorSet() {
        return ModItems.MAGE_ARMOR;
    }

    class RemainStationaryGoal
    extends Goal {
        public RemainStationaryGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return MageCloneEntity.this.shouldBeStationary();
        }
    }

    class ShootAttackGoal
    extends Goal {
        public MageCloneEntity mob;
        @Nullable
        public LivingEntity target;

        public ShootAttackGoal(MageCloneEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && !this.mob.shouldBeStationary() && this.mob.m_20270_((Entity)this.target) <= 16.0f && this.mob.m_20270_((Entity)this.target) > 5.0f && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.mob.shouldBeStationary() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null && this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                Vec3 pos = PositionUtils.getOffsetPos((Entity)this.mob, 0.3, 1.5, 0.5, this.mob.f_20883_);
                double d1 = this.target.m_20185_() - pos.f_82479_;
                double d2 = this.target.m_20227_(0.6) - pos.f_82480_;
                double d3 = this.target.m_20189_() - pos.f_82481_;
                MageMissileEntity mageMissile = new MageMissileEntity(this.mob.f_19853_, (LivingEntity)this.mob, d1 / 5.0, 5.0, d3 / 5.0);
                mageMissile.rotateToMatchMovement();
                mageMissile.m_6027_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                mageMissile.m_5602_((Entity)this.mob);
                this.mob.f_19853_.m_7967_((Entity)mageMissile);
                this.mob.m_5496_((SoundEvent)ModSoundEvents.NECROMANCER_SHOOT.get(), 1.0f, 2.0f);
            }
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        private final TargetingConditions copyOwnerTargeting;

        public CopyOwnerTargetGoal(PathfinderMob p_i47231_2_) {
            super((Mob)p_i47231_2_, false);
            this.copyOwnerTargeting = TargetingConditions.m_148352_().m_26893_();
        }

        public boolean m_8036_() {
            return MageCloneEntity.this.owner != null && MageCloneEntity.this.owner.m_5448_() != null && this.m_26150_(MageCloneEntity.this.owner.m_5448_(), this.copyOwnerTargeting);
        }

        public void m_8056_() {
            MageCloneEntity.this.m_6710_(MageCloneEntity.this.owner.m_5448_());
            super.m_8056_();
        }
    }
}

