/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_libraries.utils.GoalUtils;
import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedProps;
import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedPropsHelper;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.ReplacedModdedAttackGoal;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_mobs")
public class ReplacedIllagerEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Vindicator) {
            Vindicator vindicatorEntity = (Vindicator)entity;
            GoalUtils.removeGoal((GoalSelector)vindicatorEntity.f_21345_, MeleeAttackGoal.class);
            vindicatorEntity.f_21345_.m_25352_(4, new ReplacedModdedAttackGoal<Vindicator>(vindicatorEntity, null, 20));
            vindicatorEntity.f_21345_.m_25352_(5, (Goal)new ApproachTargetGoal((PathfinderMob)vindicatorEntity, 0.0, 1.0, true));
            AnimatedProps cap = AnimatedPropsHelper.getAnimatedPropsCapability((Mob)vindicatorEntity);
            cap.setAttackAnimationLength(7);
            cap.setAttackAnimationActionPoint(6);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Vindicator) {
            ReplacedIllagerEvents.tickDownAnimTimers((Mob)livingEntity);
        }
    }

    public static void tickDownAnimTimers(Mob mobEntity) {
        AnimatedProps cap = AnimatedPropsHelper.getAnimatedPropsCapability(mobEntity);
        if (cap.getAttackAnimationTick() > 0) {
            cap.setAttackAnimationTick(cap.getAttackAnimationTick() - 1);
        }
    }
}

