/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedProps;
import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedPropsHelper;
import com.infamous.dungeons_mobs.client.renderer.util.IGeoReplacedEntity;
import com.infamous.dungeons_mobs.entities.illagers.IllagerArmsUtil;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Vindicator;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ReplacedVindicatorEntity
implements IAnimatable,
IGeoReplacedEntity {
    public Mob entity;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    @Override
    public Mob getMob() {
        return this.entity;
    }

    @Override
    public void setMob(Mob mob) {
        this.entity = mob;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        String animation = "animation.vindicator";
        String handSide = "_right";
        if (this.entity.m_21526_()) {
            handSide = "_left";
        }
        if (this.entity.m_21205_().m_41619_()) {
            handSide = "_both";
        }
        String crossed = "";
        if (IllagerArmsUtil.armorHasCrossedArms((AbstractIllager)((Vindicator)this.entity), this.entity.m_6844_(EquipmentSlot.CHEST))) {
            crossed = "_crossed";
        }
        AnimatedProps cap = AnimatedPropsHelper.getAnimatedPropsCapability(this.entity);
        if (cap.attackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".attack" + handSide, Boolean.valueOf(true)));
        } else if (!(!this.entity.m_5912_() || event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".run" + handSide, Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".walk" + crossed, Boolean.valueOf(true)));
        } else if (((Vindicator)this.entity).m_37888_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".win", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".idle" + crossed, Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

