/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.jungle;

import com.infamous.dungeons_mobs.entities.jungle.AbstractVineEntity;
import com.infamous.dungeons_mobs.entities.jungle.PoisonQuillVineEntity;
import com.infamous.dungeons_mobs.tags.CustomTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.entity.PartEntity;

public class VinePartEntity
extends PartEntity<AbstractVineEntity> {
    public final AbstractVineEntity parentMob;
    public int segmentNumber;

    public VinePartEntity(AbstractVineEntity p_i50232_1_, int segmentNumber) {
        super((Entity)p_i50232_1_);
        this.parentMob = p_i50232_1_;
        this.segmentNumber = segmentNumber;
        this.m_6210_();
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag p_70037_1_) {
    }

    protected void m_7380_(CompoundTag p_213281_1_) {
    }

    public boolean m_6087_() {
        return this.parentMob.isOut();
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (p_70097_1_.m_7639_() != null && p_70097_1_.m_7639_().m_6095_().m_204039_(CustomTags.PLANT_MOBS)) {
            return false;
        }
        return this.m_6673_(p_70097_1_) ? false : this.parentMob.m_6469_(p_70097_1_, p_70097_2_);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public boolean isPoisonQuill() {
        return this.parentMob instanceof PoisonQuillVineEntity;
    }

    public boolean m_5829_() {
        return this.parentMob.isOut();
    }

    public EntityDimensions getSizeForSegment() {
        EntityDimensions size = EntityDimensions.m_20395_((float)0.0f, (float)0.0f);
        if (this.segmentNumber < 27 - this.parentMob.getLengthInSegments()) {
            return size;
        }
        if (this.segmentNumber == 26) {
            size = EntityDimensions.m_20395_((float)0.25f, (float)(this.isPoisonQuill() ? 1.625f : 1.375f));
        } else if (this.segmentNumber == 25) {
            size = EntityDimensions.m_20395_((float)0.5f, (float)(this.isPoisonQuill() ? 2.0f : 1.375f));
        } else if (this.segmentNumber >= 23 && this.segmentNumber <= 24) {
            size = EntityDimensions.m_20395_((float)0.75f, (float)(this.isPoisonQuill() && this.segmentNumber == 24 ? 2.0f : 1.375f));
        } else if (this.segmentNumber >= 20 && this.segmentNumber <= 22) {
            size = EntityDimensions.m_20395_((float)1.0f, (float)1.375f);
        } else if (this.segmentNumber >= 16 && this.segmentNumber <= 19) {
            size = EntityDimensions.m_20395_((float)1.25f, (float)1.375f);
        } else if (this.segmentNumber >= 11 && this.segmentNumber <= 15) {
            size = EntityDimensions.m_20395_((float)1.5f, (float)1.375f);
        } else if (this.segmentNumber >= 5 && this.segmentNumber <= 10) {
            size = EntityDimensions.m_20395_((float)1.75f, (float)1.375f);
        } else if (this.segmentNumber >= 1 && this.segmentNumber <= 4) {
            size = EntityDimensions.m_20395_((float)2.0f, (float)1.375f);
        }
        return size;
    }

    public float getYOffsetForSegment() {
        float extraHeight = this.isPoisonQuill() && this.segmentNumber > 24 ? 0.625f * (float)(-24 + this.segmentNumber) : 0.0f;
        return 1.375f * (float)(this.segmentNumber - 1) - 35.75f + this.parentMob.getLengthInBlocks() + extraHeight;
    }

    public EntityDimensions m_6972_(Pose p_213305_1_) {
        return this.getSizeForSegment();
    }

    public Packet<?> m_5654_() {
        throw new UnsupportedOperationException();
    }
}

