/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.jungle;

import com.infamous.dungeons_mobs.entities.jungle.AbstractVineEntity;
import com.infamous.dungeons_mobs.entities.summonables.KelpTrapEntity;
import com.infamous.dungeons_mobs.entities.summonables.SimpleTrapEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.AquaticMoveHelperController;
import com.infamous.dungeons_mobs.goals.GoToWaterGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.goals.SwimUpGoal;
import com.infamous.dungeons_mobs.interfaces.IAquaticMob;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.tags.CustomTags;
import com.infamous.dungeons_mobs.utils.GeomancyHelper;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class WhispererEntity
extends Monster
implements IAnimatable,
IAquaticMob {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(WhispererEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int summonQGVAnimationTick;
    public int summonQGVAnimationLength = 40;
    public int summonQGVAnimationActionPoint = 20;
    public int summonPQVAnimationTick;
    public int summonPQVAnimationLength = 70;
    public int summonPQVAnimationActionPoint1 = 53;
    public int summonPQVAnimationActionPoint2 = 30;
    public int grappleAnimationTick;
    public int grappleAnimationLength = 65;
    public int grappleAnimationActionPoint = 23;
    public int underwaterGrappleAnimationActionPoint = 20;
    public int attackAnimationTick;
    public int attackAnimationLength = 30;
    public int attackAnimationActionPoint = 18;
    public int underwaterAttackAnimationActionPoint = 16;
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    protected final GroundPathNavigation climberNavigation;

    public WhispererEntity(EntityType<? extends WhispererEntity> type, Level world) {
        super(type, world);
        this.f_19793_ = 1.0f;
        if (this.isWavewhisperer()) {
            this.f_21342_ = new AquaticMoveHelperController<WhispererEntity>(this);
            this.m_21441_(BlockPathTypes.WATER, 0.0f);
        }
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, world);
        this.groundNavigation = new GroundPathNavigation((Mob)this, world);
        this.climberNavigation = new WallClimberNavigation((Mob)this, world);
        if (!this.isWavewhisperer()) {
            // empty if block
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        if (this.isWavewhisperer()) {
            this.registerWavewhispererGoals();
        } else {
            this.registerWhispererGoals();
        }
    }

    public void registerWhispererGoals() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BasicAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new GrappleGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SummonPQVAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SummonQGVGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 4.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 4.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new ApproachTargetGoal((PathfinderMob)this, 7.0, 1.1, true));
        this.f_21345_.m_25352_(7, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public boolean isSpellcasting() {
        return this.summonPQVAnimationTick > 0 || this.summonQGVAnimationTick > 0 || this.grappleAnimationTick > 0;
    }

    public void registerWavewhispererGoals() {
        this.f_21345_.m_25352_(1, (Goal)new GoToWaterGoal((PathfinderMob)this, 1.25){

            @Override
            public boolean m_8036_() {
                if (this.mob.m_20069_()) {
                    return false;
                }
                Vec3 vector3d = this.getWaterPos();
                if (vector3d == null) {
                    return false;
                }
                this.wantedX = vector3d.f_82479_;
                this.wantedY = vector3d.f_82480_;
                this.wantedZ = vector3d.f_82481_;
                return true;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new BasicAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new GrappleGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SummonPQVAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SummonQGVGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 4.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 4.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new ApproachTargetGoal((PathfinderMob)this, 7.0, 1.1, true));
        this.f_21345_.m_25352_(7, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(8, new SwimUpGoal<WhispererEntity>(this, 1.2, this.f_19853_.m_5736_()));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.isWavewhisperer() && !this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
        }
        if (this.isClimbing()) {
            this.f_20883_ = this.f_20885_;
        }
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_70839_1_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_70839_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public boolean m_6147_() {
        return !this.isWavewhisperer() && this.isClimbing();
    }

    public boolean isWavewhisperer() {
        return this.m_6095_() == ModEntityTypes.WAVEWHISPERER.get();
    }

    public boolean isInWrongHabitat() {
        return this.isWavewhisperer() && !this.m_20072_();
    }

    protected int m_7302_(int p_70682_1_) {
        return this.isWavewhisperer() ? p_70682_1_ : super.m_7302_(p_70682_1_);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 17.5).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22278_, 0.25);
    }

    public void m_8032_() {
        SoundEvent soundeventVocal = this.m_7515_();
        SoundEvent soundeventFoley = this.getAmbientSoundFoley();
        this.playSound(soundeventVocal, soundeventFoley, this.m_6121_(), this.m_6100_(), this.m_6121_(), this.m_6100_());
    }

    protected void m_6677_(DamageSource p_184581_1_) {
        this.f_21363_ = -this.m_8100_();
        SoundEvent soundeventVocal = this.m_7975_(p_184581_1_);
        SoundEvent soundeventFoley = this.getHurtSoundFoley(p_184581_1_);
        this.playSound(soundeventVocal, soundeventFoley, this.m_6121_(), this.m_6100_(), this.m_6121_(), this.m_6100_());
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.m_5496_(this.getStepSound(), 0.5f, 1.0f);
        this.m_5496_(this.getStepSoundFoley(), 0.5f, 1.0f);
    }

    public void playSound(SoundEvent vocalSound, SoundEvent foleySound, float vocalVolume, float vocalPitch, float foleyVolume, float foleyPitch) {
        if (!this.m_20067_()) {
            if (vocalSound != null) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), vocalSound, this.m_5720_(), vocalVolume, vocalPitch);
            }
            if (foleySound != null) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), foleySound, this.m_5720_(), foleyVolume, foleyPitch);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return this.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_IDLE.get() : (SoundEvent)ModSoundEvents.WHISPERER_IDLE_VOCAL.get();
    }

    protected SoundEvent getAmbientSoundFoley() {
        return this.isWavewhisperer() ? null : (SoundEvent)ModSoundEvents.WHISPERER_IDLE_FOLEY.get();
    }

    public int m_8100_() {
        return 150;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return this.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_HURT.get() : (SoundEvent)ModSoundEvents.WHISPERER_HURT_VOCAL.get();
    }

    protected SoundEvent getHurtSoundFoley(DamageSource p_184601_1_) {
        return this.isWavewhisperer() ? null : (SoundEvent)ModSoundEvents.WHISPERER_HURT_FOLEY.get();
    }

    protected SoundEvent m_5592_() {
        return this.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_DEATH.get() : (SoundEvent)ModSoundEvents.WHISPERER_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSoundEvents.WHISPERER_STEP_VOCAL.get();
    }

    protected SoundEvent getStepSoundFoley() {
        return (SoundEvent)ModSoundEvents.WHISPERER_STEP_FOLEY.get();
    }

    protected void m_5625_(float p_203006_1_) {
        this.m_5496_(this.m_5501_(), 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.4f);
    }

    public void m_5496_(SoundEvent p_184185_1_, float p_184185_2_, float p_184185_3_) {
        if (p_184185_1_ == this.m_5592_()) {
            super.m_5496_(p_184185_1_, p_184185_2_, p_184185_3_ / 2.0f);
            super.m_5496_((SoundEvent)ModSoundEvents.WHISPERER_STEP_FOLEY.get(), p_184185_2_, p_184185_3_);
            super.m_5496_((SoundEvent)ModSoundEvents.WHISPERER_HURT_FOLEY.get(), p_184185_2_, p_184185_3_);
        } else {
            super.m_5496_(p_184185_1_, p_184185_2_, p_184185_3_);
        }
    }

    protected SoundEvent m_5501_() {
        return this.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_STEP.get() : null;
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        if (!this.f_19853_.f_46443_ && this.isInWrongHabitat() && this.f_19796_.nextInt(200) == 0) {
            this.m_6074_();
        }
    }

    public void tickDownAnimTimers() {
        if (this.summonQGVAnimationTick > 0) {
            --this.summonQGVAnimationTick;
        }
        if (this.summonPQVAnimationTick > 0) {
            --this.summonPQVAnimationTick;
        }
        if (this.grappleAnimationTick > 0) {
            --this.grappleAnimationTick;
        }
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 4) {
            this.summonQGVAnimationTick = this.summonQGVAnimationLength;
        } else if (p_70103_1_ == 5) {
            this.summonPQVAnimationTick = this.summonPQVAnimationLength;
        } else if (p_70103_1_ == 6) {
            this.grappleAnimationTick = this.grappleAnimationLength;
        } else if (p_70103_1_ == 7) {
            this.attackAnimationTick = this.attackAnimationLength;
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource p_147189_) {
        return false;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.attackAnimationTick > 0) {
            if (this.m_204029_(FluidTags.f_13131_) && this.isWavewhisperer()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("wavewhisperer_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.summonPQVAnimationTick > 0) {
            if (this.m_204029_(FluidTags.f_13131_) && this.isWavewhisperer()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("wavewhisperer_summon_pa", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_summon_pqv", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.summonQGVAnimationTick > 0) {
            if (this.m_204029_(FluidTags.f_13131_) && this.isWavewhisperer()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("wavewhisperer_summon_qgk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_summon_qgv", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.grappleAnimationTick > 0) {
            if (this.m_204029_(FluidTags.f_13131_) && this.isWavewhisperer()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("wavewhisperer_grapple", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_grapple", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.isClimbing()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_climb", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            if (this.m_204029_(FluidTags.f_13131_) && this.isWavewhisperer()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("wavewhisperer_swim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.m_20069_() && this.isWavewhisperer()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wavewhisperer_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_7307_(Entity p_184191_1_) {
        if (super.m_7307_(p_184191_1_)) {
            return true;
        }
        if (p_184191_1_ instanceof LivingEntity && ((LivingEntity)p_184191_1_).m_6095_().m_204039_(CustomTags.PLANT_MOBS)) {
            return this.m_5647_() == null && p_184191_1_.m_5647_() == null;
        }
        return false;
    }

    public boolean m_6063_() {
        return this.isWavewhisperer() ? !this.m_6069_() : super.m_6063_();
    }

    public void m_7023_(Vec3 travelVec) {
        if (this.isWavewhisperer()) {
            this.checkAquaticTravel((Mob)this, travelVec);
        } else {
            this.normalTravel(travelVec);
        }
    }

    @Override
    public void normalTravel(Vec3 travelVec) {
        super.m_7023_(travelVec);
    }

    public void m_5844_() {
        if (this.isWavewhisperer()) {
            this.updateNavigation((Mob)this);
        } else {
            super.m_5844_();
        }
    }

    @Override
    public boolean isSearchingForLand() {
        return false;
    }

    @Override
    public void setNavigation(PathNavigation navigation) {
        this.f_21344_ = navigation;
    }

    @Override
    public GroundPathNavigation getGroundNavigation() {
        return this.groundNavigation;
    }

    @Override
    public WaterBoundPathNavigation getWaterNavigation() {
        return this.waterNavigation;
    }

    @Override
    public void setSearchingForLand(boolean searchingForLand) {
    }

    @Override
    public <T extends Mob> boolean wantsToSwim(T aquaticMob) {
        return this.isWavewhisperer() ? this.m_5448_() != null : false;
    }

    @Override
    public <T extends LivingEntity> boolean okTarget(T aquaticMob, LivingEntity target) {
        return true;
    }

    public boolean canUseGoals() {
        return this.isWavewhisperer() && this.m_20072_() || !this.isWavewhisperer();
    }

    class BasicAttackGoal
    extends Goal {
        public WhispererEntity mob;
        @Nullable
        public LivingEntity target;

        public BasicAttackGoal(WhispererEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.m_20270_((Entity)this.target) <= 3.0f && this.animationsUseable() && this.mob.m_142582_((Entity)this.target) && this.mob.canUseGoals() && this.mob.f_19796_.nextInt(20) == 0;
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.attackAnimationTick = this.mob.attackAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)7);
            this.mob.m_5496_((SoundEvent)ModSoundEvents.WHISPERER_ATTACK_FOLEY.get(), 1.0f, 1.0f);
        }

        public void m_8037_() {
            int actionPoint;
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            int n = actionPoint = this.mob.isWavewhisperer() ? this.mob.underwaterAttackAnimationActionPoint : this.mob.attackAnimationActionPoint;
            if (this.mob.attackAnimationTick == this.mob.attackAnimationActionPoint + 5) {
                this.mob.m_5496_(this.mob.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_ATTACK.get() : (SoundEvent)ModSoundEvents.WHISPERER_ATTACK_VOCAL.get(), 1.25f, 1.0f);
            }
            if (this.target != null && (double)this.mob.m_20270_((Entity)this.target) < 3.5 && this.mob.attackAnimationTick == actionPoint) {
                this.mob.m_7327_((Entity)this.target);
            }
        }

        public boolean animationsUseable() {
            return this.mob.attackAnimationTick <= 0;
        }
    }

    class GrappleGoal
    extends Goal {
        public WhispererEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;

        public GrappleGoal(WhispererEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.m_20270_((Entity)this.target) <= 15.0f && this.animationsUseable() && this.mob.m_142582_((Entity)this.target) && this.mob.canUseGoals() && this.mob.f_19797_ >= this.nextUseTime;
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.grappleAnimationTick = this.mob.grappleAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)6);
            this.mob.m_5496_((SoundEvent)ModSoundEvents.WHISPERER_GRAPPLE_FOLEY.get(), 1.0f, 1.0f);
        }

        public void m_8037_() {
            int actionPoint;
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.mob.grappleAnimationTick == this.mob.grappleAnimationLength - 30) {
                this.mob.m_5496_(this.mob.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_GRAPPLE.get() : (SoundEvent)ModSoundEvents.WHISPERER_GRAPPLE_VOCAL.get(), 1.25f, 1.0f);
            }
            int n = actionPoint = this.mob.isWavewhisperer() ? this.mob.underwaterGrappleAnimationActionPoint : this.mob.grappleAnimationActionPoint;
            if (this.target != null && this.mob.grappleAnimationTick == actionPoint) {
                if (this.mob.isWavewhisperer()) {
                    KelpTrapEntity trap = (KelpTrapEntity)((EntityType)ModEntityTypes.KELP_TRAP.get()).m_20615_(this.mob.f_19853_);
                    trap.m_6027_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
                    PositionUtils.moveToCorrectHeight(trap);
                    trap.owner = this.mob;
                    this.mob.f_19853_.m_7967_((Entity)trap);
                } else {
                    SimpleTrapEntity trap = (SimpleTrapEntity)((EntityType)ModEntityTypes.SIMPLE_TRAP.get()).m_20615_(this.mob.f_19853_);
                    trap.m_6027_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
                    trap.setTrapType(1);
                    PositionUtils.moveToCorrectHeight(trap);
                    trap.owner = this.mob;
                    this.mob.f_19853_.m_7967_((Entity)trap);
                }
            }
        }

        public void m_8041_() {
            this.nextUseTime = this.mob.f_19797_ + (200 + this.mob.f_19796_.nextInt(400));
        }

        public boolean animationsUseable() {
            return this.mob.grappleAnimationTick <= 0;
        }
    }

    class SummonPQVAttackGoal
    extends Goal {
        public WhispererEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;

        public SummonPQVAttackGoal(WhispererEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && (double)this.mob.m_20270_((Entity)this.target) <= 12.5 && this.animationsUseable() && this.mob.m_142582_((Entity)this.target) && this.mob.canUseGoals() && this.mob.f_19797_ >= this.nextUseTime;
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.summonPQVAnimationTick = this.mob.summonPQVAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)5);
            this.mob.m_5496_(this.mob.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_SUMMON_PA_FOLEY.get() : (SoundEvent)ModSoundEvents.WHISPERER_SUMMON_PQV_FOLEY.get(), 1.0f, 1.0f);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.mob.summonPQVAnimationTick == this.mob.summonPQVAnimationLength - 12) {
                this.mob.m_5496_(this.mob.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_SUMMON_PA_VOCAL.get() : (SoundEvent)ModSoundEvents.WHISPERER_SUMMON_PQV_VOCAL.get(), 1.25f, 1.0f);
            }
            if (this.target != null && (this.mob.summonPQVAnimationTick == this.mob.summonPQVAnimationActionPoint1 || this.mob.summonPQVAnimationTick == this.mob.summonPQVAnimationActionPoint2)) {
                boolean movingOnX = this.mob.f_19796_.nextBoolean();
                GeomancyHelper.summonOffensiveVine((LivingEntity)this.mob, (LivingEntity)this.mob, (EntityType<? extends AbstractVineEntity>)(this.mob.isWavewhisperer() ? (EntityType)ModEntityTypes.POISON_ANEMONE.get() : (EntityType)ModEntityTypes.POISON_QUILL_VINE.get()), movingOnX ? (this.mob.f_19796_.nextBoolean() ? 3 : -3) : 0, !movingOnX ? (this.mob.f_19796_.nextBoolean() ? 3 : -3) : 0);
            }
        }

        public void m_8041_() {
            this.nextUseTime = this.mob.f_19797_ + (350 + this.mob.f_19796_.nextInt(150));
        }

        public boolean animationsUseable() {
            return this.mob.summonPQVAnimationTick <= 0;
        }
    }

    class SummonQGVGoal
    extends Goal {
        public WhispererEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;

        public SummonQGVGoal(WhispererEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.m_20270_((Entity)this.target) <= 15.0f && this.animationsUseable() && this.mob.m_142582_((Entity)this.target) && this.mob.canUseGoals() && this.mob.f_19797_ >= this.nextUseTime;
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.summonQGVAnimationTick = this.mob.summonQGVAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
            this.mob.m_5496_((SoundEvent)ModSoundEvents.WHISPERER_SUMMON_QGV_FOLEY.get(), 1.0f, 1.0f);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.mob.summonQGVAnimationTick == this.mob.summonQGVAnimationLength - 5) {
                this.mob.m_5496_(this.mob.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_SUMMON_QGK.get() : (SoundEvent)ModSoundEvents.WHISPERER_SUMMON_QGV_VOCAL.get(), 1.25f, 1.0f);
            }
            if (this.target != null && this.mob.summonQGVAnimationTick == this.mob.summonQGVAnimationActionPoint) {
                int[] rowToRemove = (int[])Util.m_137545_((Object[])GeomancyHelper.CONFIG_1_ROWS, (Random)WhispererEntity.this.m_21187_());
                GeomancyHelper.summonAreaDenialVineTrap((LivingEntity)this.mob, this.target, (EntityType<? extends AbstractVineEntity>)(this.mob.isWavewhisperer() ? (EntityType)ModEntityTypes.QUICK_GROWING_KELP.get() : (EntityType)ModEntityTypes.QUICK_GROWING_VINE.get()), rowToRemove);
            }
        }

        public void m_8041_() {
            this.nextUseTime = this.mob.f_19797_ + (150 + this.mob.f_19796_.nextInt(50));
        }

        public boolean animationsUseable() {
            return this.mob.summonQGVAnimationTick <= 0;
        }
    }
}

