/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.redstone;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.summonables.ConstructEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class RedstoneMineEntity
extends Entity
implements IAnimatable {
    public static final EntityDataAccessor<Integer> LIFE_TICKS = SynchedEntityData.m_135353_(ConstructEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LivingEntity caster;
    private UUID casterUuid;
    private float explosionRadius = 1.0f;
    public static final int LIFE_TIME = 250;
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public RedstoneMineEntity(Level worldIn) {
        super((EntityType)ModEntityTypes.REDSTONE_MINE.get(), worldIn);
    }

    public RedstoneMineEntity(EntityType<? extends RedstoneMineEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public RedstoneMineEntity(Level worldIn, double x, double y, double z, int delay, LivingEntity casterIn) {
        this((EntityType<? extends RedstoneMineEntity>)((EntityType)ModEntityTypes.REDSTONE_MINE.get()), worldIn);
        this.setLifeTicks(delay);
        this.setCaster(casterIn);
        this.m_6034_(x, y, z);
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getLifeTicks() == 6) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_mine.deactive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        if (this.getLifeTicks() == 250) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_mine.activate", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        if (this.getLifeTicks() < 247 && this.getLifeTicks() > 4) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_mine.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public void setCaster(@Nullable LivingEntity livingEntity) {
        this.caster = livingEntity;
        this.casterUuid = livingEntity == null ? null : livingEntity.m_142081_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected float getRandomPitch() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 4) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.REDSTONE_SPARK.get(), this.m_20208_(1.1), this.m_20187_(), this.m_20262_(1.1), -0.05 + this.f_19796_.nextDouble() * 0.05, -0.05 + this.f_19796_.nextDouble() * 0.05, -0.05 + this.f_19796_.nextDouble() * 0.05);
            }
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.f_19796_.nextInt(20) == 0) {
            this.m_5496_((SoundEvent)ModSoundEvents.REDSTONE_GOLEM_SPARK.get(), 0.1f, this.getRandomPitch());
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        }
        this.setLifeTicks(this.getLifeTicks() - 1);
        if (!this.f_19853_.f_46443_) {
            if (this.getLifeTicks() <= 0) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else if (this.getLifeTicks() < 247 && this.getLifeTicks() > 6) {
                for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_().m_82377_(0.3, 0.3, 0.3))) {
                    this.explode(livingentity);
                }
            }
        }
    }

    private void explode(LivingEntity livingentity) {
        LivingEntity Caster = this.getCaster();
        if (livingentity.m_6084_() && !livingentity.m_20147_()) {
            if (Caster != null) {
                if (!Caster.m_7307_((Entity)livingentity) || livingentity != Caster) {
                    this.f_19853_.m_46511_((Entity)Caster, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), this.explosionRadius, Explosion.BlockInteraction.NONE);
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else {
                this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), this.explosionRadius, Explosion.BlockInteraction.NONE);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LIFE_TICKS, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setLifeTicks(compound.m_128451_("LifeTicks"));
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("LifeTicks", this.getLifeTicks());
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
    }

    public int getLifeTicks() {
        return (Integer)this.f_19804_.m_135370_(LIFE_TICKS);
    }

    public void setLifeTicks(int p_189794_1_) {
        this.f_19804_.m_135381_(LIFE_TICKS, (Object)p_189794_1_);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

