/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.google.common.collect.Lists;
import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class AreaDamageEntity
extends Entity {
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(AreaDamageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SIZE_TO_REACH = SynchedEntityData.m_135353_(AreaDamageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> GROW_SPEED = SynchedEntityData.m_135353_(AreaDamageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y_SIZE = SynchedEntityData.m_135353_(AreaDamageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> PARTICLE_TYPE = SynchedEntityData.m_135353_(AreaDamageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EXTRA_TIME = SynchedEntityData.m_135353_(AreaDamageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float damage;
    public DamageSource damageSource = DamageSource.f_19318_;
    public LivingEntity owner;
    public boolean constantDamage;
    public List<Entity> damagedEntities = Lists.newArrayList();
    public boolean friendlyFire;
    public double knockbackAmount;
    public double knockbackAmountY;
    public boolean disableShields;
    public int disableShieldTime;
    public int extraTimeTick;
    public List<AreaDamageEntity> connectedAreaDamages = Lists.newArrayList();

    public AreaDamageEntity(Level world) {
        super((EntityType)ModEntityTypes.AREA_DAMAGE.get(), world);
    }

    public AreaDamageEntity(EntityType<? extends AreaDamageEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityDimensions m_6972_(Pose p_213305_1_) {
        return EntityDimensions.m_20395_((float)this.getSize(), (float)this.getYSize());
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public boolean canEntityBeDamaged(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (this.owner != null && entity == this.owner) {
            return false;
        }
        if (this.owner != null && this.owner.m_7307_(entity) && !this.friendlyFire) {
            return false;
        }
        if (!this.damagedEntities.isEmpty() && !this.constantDamage && this.damagedEntities.contains(entity)) {
            return false;
        }
        if (!this.connectedAreaDamages.isEmpty()) {
            boolean canConnectedAreaDamagesHarm = true;
            for (AreaDamageEntity areaDamage : this.connectedAreaDamages) {
                if (areaDamage.damagedEntities.isEmpty() || areaDamage.constantDamage || !areaDamage.damagedEntities.contains(entity)) continue;
                canConnectedAreaDamagesHarm = false;
            }
            return canConnectedAreaDamagesHarm;
        }
        return true;
    }

    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 1) {
            for (int particleAmount = 0; particleAmount < 25; ++particleAmount) {
                int k;
                int j;
                int i = Mth.m_14107_((double)this.m_20185_());
                BlockPos pos = new BlockPos(i, j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f)), k = Mth.m_14107_((double)this.m_20189_()));
                BlockState blockstate = this.f_19853_.m_8055_(pos);
                if (blockstate.m_60795_()) continue;
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_(), 0.0, 0.0, 0.0);
            }
            for (int i = 0; i < 60; ++i) {
                Vec3 vector3d = this.m_20182_();
                double d0 = this.f_19796_.nextGaussian() * 15.0;
                double d1 = (double)this.f_19796_.nextFloat() * 1.75;
                double d2 = this.f_19796_.nextGaussian() * 15.0;
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.DUST.get(), vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, d0, d1, d2);
            }
        } else if (p_70103_1_ == 2) {
            for (int particleAmount = 0; particleAmount < 25; ++particleAmount) {
                int k;
                int j;
                int i = Mth.m_14107_((double)this.m_20185_());
                BlockPos pos = new BlockPos(i, j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f)), k = Mth.m_14107_((double)this.m_20189_()));
                BlockState blockstate = this.f_19853_.m_8055_(pos);
                if (blockstate.m_60795_()) continue;
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_(), 0.0, 0.0, 0.0);
            }
            for (int i = 0; i < 50; ++i) {
                Vec3 vector3d = this.m_20182_();
                double d0 = this.f_19796_.nextGaussian() * 0.5;
                double d1 = (double)this.f_19796_.nextFloat() * 2.0;
                double d2 = this.f_19796_.nextGaussian() * 0.5;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, d0, d1, d2);
            }
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    public static AreaDamageEntity spawnAreaDamage(Level level, Vec3 pos, LivingEntity owner, float damage, DamageSource damageSource, float size, float sizeToReach, float growSpeed, float ySize, int extraTime, boolean constantDamage, boolean friendlyFire, double knockbackAmount, double knockbackAmountY, boolean disableShields, int disableShieldTime, int particleVariant) {
        AreaDamageEntity areaDamage = (AreaDamageEntity)((EntityType)ModEntityTypes.AREA_DAMAGE.get()).m_20615_(level);
        areaDamage.m_6027_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        areaDamage.owner = owner;
        areaDamage.damage = damage;
        areaDamage.damageSource = damageSource;
        areaDamage.setSize(size);
        areaDamage.setSizeToReach(sizeToReach);
        areaDamage.setGrowSpeed(growSpeed);
        areaDamage.setYSize(ySize);
        areaDamage.constantDamage = constantDamage;
        areaDamage.friendlyFire = friendlyFire;
        areaDamage.knockbackAmount = knockbackAmount;
        areaDamage.knockbackAmountY = knockbackAmountY;
        areaDamage.disableShields = disableShields;
        areaDamage.disableShieldTime = disableShieldTime;
        areaDamage.setParticleType(particleVariant);
        areaDamage.setExtraTime(extraTime);
        return areaDamage;
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_(), Entity::m_6084_);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (this.f_19853_.f_46443_ || !this.canEntityBeDamaged(entity)) continue;
                entity.m_6469_(this.damageSource, this.damage);
                if ((double)this.m_20270_(entity) >= 0.5) {
                    double d0 = entity.m_20185_() - this.m_20185_();
                    double d1 = entity.m_20189_() - this.m_20189_();
                    double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                    entity.m_5997_(d0 / d2 * this.knockbackAmount, this.knockbackAmountY, d1 / d2 * this.knockbackAmount);
                }
                if (entity instanceof LivingEntity && this.disableShields) {
                    this.disableShield((LivingEntity)entity, this.disableShieldTime);
                }
                this.damagedEntities.add(entity);
            }
        }
        if (this.getParticleType() > 0) {
            this.f_19853_.m_7605_((Entity)this, (byte)this.getParticleType());
            this.setParticleType(0);
        }
        if (this.getSize() < this.getSizeToReach()) {
            this.setSize(this.getSize() + this.getGrowSpeed());
        }
        if (this.getSize() >= this.getSizeToReach()) {
            ++this.extraTimeTick;
        }
        if (!this.f_19853_.f_46443_ && (this.getExtraTime() > 0 && this.extraTimeTick >= this.getExtraTime() || this.getExtraTime() <= 0 && this.getSize() >= this.getSizeToReach())) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void disableShield(LivingEntity livingEntity, int ticks) {
        if (livingEntity instanceof Player && livingEntity.m_21254_()) {
            ((Player)livingEntity).m_36335_().m_41524_(livingEntity.m_21120_(livingEntity.m_7655_()).m_41720_(), ticks);
            livingEntity.m_5810_();
            livingEntity.f_19853_.m_7605_((Entity)livingEntity, (byte)30);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SIZE_TO_REACH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(Y_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(GROW_SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PARTICLE_TYPE, (Object)0);
        this.f_19804_.m_135372_(EXTRA_TIME, (Object)0);
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public void setSize(float attached) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(attached));
    }

    public float getSizeToReach() {
        return ((Float)this.f_19804_.m_135370_(SIZE_TO_REACH)).floatValue();
    }

    public void setSizeToReach(float attached) {
        this.f_19804_.m_135381_(SIZE_TO_REACH, (Object)Float.valueOf(attached));
    }

    public float getYSize() {
        return ((Float)this.f_19804_.m_135370_(Y_SIZE)).floatValue();
    }

    public void setYSize(float attached) {
        this.f_19804_.m_135381_(Y_SIZE, (Object)Float.valueOf(attached));
    }

    public float getGrowSpeed() {
        return ((Float)this.f_19804_.m_135370_(GROW_SPEED)).floatValue();
    }

    public void setGrowSpeed(float attached) {
        this.f_19804_.m_135381_(GROW_SPEED, (Object)Float.valueOf(attached));
    }

    public int getParticleType() {
        return (Integer)this.f_19804_.m_135370_(PARTICLE_TYPE);
    }

    public void setParticleType(int attached) {
        this.f_19804_.m_135381_(PARTICLE_TYPE, (Object)attached);
    }

    public int getExtraTime() {
        return (Integer)this.f_19804_.m_135370_(EXTRA_TIME);
    }

    public void setExtraTime(int attached) {
        this.f_19804_.m_135381_(EXTRA_TIME, (Object)attached);
    }

    protected void m_7378_(CompoundTag p_70037_1_) {
        this.setSize(p_70037_1_.m_128457_("Size"));
        this.setSizeToReach(p_70037_1_.m_128457_("SizeToReach"));
        this.setYSize(p_70037_1_.m_128457_("YSize"));
        this.setGrowSpeed(p_70037_1_.m_128457_("GrowSpeed"));
        this.setParticleType(p_70037_1_.m_128451_("ParticleType"));
        this.setExtraTime(p_70037_1_.m_128451_("ExtraTime"));
        this.damage = p_70037_1_.m_128457_("Damage");
        this.constantDamage = p_70037_1_.m_128471_("ConstantDamage");
        this.knockbackAmount = p_70037_1_.m_128459_("KnockbackAmount");
        this.knockbackAmountY = p_70037_1_.m_128459_("KnockbackAmountY");
        this.disableShieldTime = p_70037_1_.m_128451_("DisableShieldTime");
        this.disableShields = p_70037_1_.m_128471_("DisableShields");
    }

    protected void m_7380_(CompoundTag p_213281_1_) {
        p_213281_1_.m_128350_("Size", this.getSize());
        p_213281_1_.m_128350_("SizeToReach", this.getSizeToReach());
        p_213281_1_.m_128350_("YSize", this.getYSize());
        p_213281_1_.m_128350_("GrowSpeed", this.getGrowSpeed());
        p_213281_1_.m_128405_("ParticleType", this.getParticleType());
        p_213281_1_.m_128350_("Damage", this.damage);
        p_213281_1_.m_128379_("ConstantDamage", this.constantDamage);
        p_213281_1_.m_128347_("KnockbackAmount", this.knockbackAmount);
        p_213281_1_.m_128347_("KnockbackAmountY", this.knockbackAmountY);
        p_213281_1_.m_128405_("DisableShieldTime", this.disableShieldTime);
        p_213281_1_.m_128379_("DisableShields", this.disableShields);
        p_213281_1_.m_128405_("ExtraTime", this.getExtraTime());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

