/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class WindcallerTornadoEntity
extends Entity
implements IAnimatable {
    private static final EntityDataAccessor<Boolean> BLAST = SynchedEntityData.m_135353_(WindcallerTornadoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int lifeTime;
    public static EntityDimensions blastDimensions = EntityDimensions.m_20395_((float)0.75f, (float)2.0f);

    public WindcallerTornadoEntity(Level worldIn) {
        super((EntityType)ModEntityTypes.TORNADO.get(), worldIn);
    }

    public WindcallerTornadoEntity(EntityType<? extends WindcallerTornadoEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityDimensions m_6972_(Pose p_213305_1_) {
        return this.isBlast() ? blastDimensions : super.m_6972_(p_213305_1_);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 1.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.isBlast()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("windcaller_tornado_blast", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("windcaller_tornado_lift", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_6075_() {
        int removeTime;
        super.m_6075_();
        this.m_6210_();
        if (!this.isBlast()) {
            List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_(), Entity::m_6084_);
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (this.lifeTime != 15) continue;
                    livingEntity.m_5997_(0.0, 1.5, 0.0);
                }
            }
            if (this.lifeTime >= 15 && this.lifeTime < 30 && this.f_19853_.f_46443_) {
                for (int i = 0; i < 3; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.WIND.get(), this.m_20208_(0.5), this.m_20187_() - 2.0, this.m_20262_(0.5), (this.f_19796_.nextDouble() - 0.5) * 1.0, 5.0, (this.f_19796_.nextDouble() - 0.5) * 1.0);
                }
            }
        }
        ++this.lifeTime;
        int n = removeTime = this.isBlast() ? 14 : 36;
        if (this.lifeTime >= removeTime && !this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BLAST, (Object)false);
    }

    protected void m_7378_(CompoundTag p_70037_1_) {
    }

    protected void m_7380_(CompoundTag p_213281_1_) {
    }

    public boolean isBlast() {
        return (Boolean)this.f_19804_.m_135370_(BLAST);
    }

    public void setBlast(boolean attached) {
        this.f_19804_.m_135381_(BLAST, (Object)attached);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

