/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.water;

import com.infamous.dungeons_mobs.goals.AquaticMoveHelperController;
import com.infamous.dungeons_mobs.goals.GoToBeachGoal;
import com.infamous.dungeons_mobs.goals.GoToWaterGoal;
import com.infamous.dungeons_mobs.goals.SwimUpGoal;
import com.infamous.dungeons_mobs.interfaces.IAquaticMob;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.mojang.math.Vector3f;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class SunkenSkeletonEntity
extends AbstractSkeleton
implements CrossbowAttackMob,
IAquaticMob {
    private final RangedBowAttackGoal<SunkenSkeletonEntity> bowGoal = new RangedBowAttackGoal((Monster)this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

        public boolean m_8036_() {
            return super.m_8036_() && SunkenSkeletonEntity.this.okTarget((LivingEntity)SunkenSkeletonEntity.this, SunkenSkeletonEntity.this.m_5448_());
        }

        public boolean m_8045_() {
            return super.m_8045_() && SunkenSkeletonEntity.this.okTarget((LivingEntity)SunkenSkeletonEntity.this, SunkenSkeletonEntity.this.m_5448_());
        }
    };
    private final RangedCrossbowAttackGoal<SunkenSkeletonEntity> crossbowGoal = new RangedCrossbowAttackGoal((Monster)this, 1.2, 10.0f);
    private static final EntityDataAccessor<Boolean> CHARGING_CROSSBOW = SynchedEntityData.m_135353_(SunkenSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean searchingForLand;
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    private final boolean isConstructed;

    public SunkenSkeletonEntity(EntityType<? extends SunkenSkeletonEntity> entityType, Level world) {
        super(entityType, world);
        this.isConstructed = true;
        this.f_19793_ = 1.0f;
        this.f_21342_ = new AquaticMoveHelperController<SunkenSkeletonEntity>(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, world);
        this.groundNavigation = new GroundPathNavigation((Mob)this, world);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return AbstractSkeleton.m_32166_();
    }

    public boolean m_6914_(LevelReader worldReader) {
        return worldReader.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return !this.m_6069_();
    }

    public void m_7023_(Vec3 travelVec) {
        this.checkAquaticTravel((Mob)this, travelVec);
    }

    @Override
    public void normalTravel(Vec3 travelVec) {
        super.m_7023_(travelVec);
    }

    public void m_5844_() {
        this.updateNavigation((Mob)this);
    }

    @Override
    public boolean isSearchingForLand() {
        return this.searchingForLand;
    }

    @Override
    public void setNavigation(PathNavigation navigation) {
        this.f_21344_ = navigation;
    }

    @Override
    public GroundPathNavigation getGroundNavigation() {
        return this.groundNavigation;
    }

    @Override
    public WaterBoundPathNavigation getWaterNavigation() {
        return this.waterNavigation;
    }

    @Override
    public void setSearchingForLand(boolean searchingForLand) {
        this.searchingForLand = searchingForLand;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new GoToWaterGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, new GoToBeachGoal<SunkenSkeletonEntity>(this, 1.0));
        this.f_21345_.m_25352_(6, new SwimUpGoal<SunkenSkeletonEntity>(this, 1.2, this.f_19853_.m_5736_()));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{SunkenSkeletonEntity.class}).m_26044_(new Class[]{SunkenSkeletonEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, target -> this.okTarget((LivingEntity)this, (LivingEntity)target)));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    public void m_32164_() {
        if (this.isConstructed && this.f_19853_ != null && !this.f_19853_.f_46443_) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            this.f_21345_.m_25363_(this.crossbowGoal);
            ItemStack bowStack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            ItemStack crossbowStack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof CrossbowItem));
            if (bowStack.m_41720_() instanceof BowItem) {
                int i = 20;
                if (this.f_19853_.m_46791_() != Difficulty.HARD) {
                    i = 40;
                }
                this.bowGoal.m_25797_(i);
                this.f_21345_.m_25352_(2, this.bowGoal);
            } else if (crossbowStack.m_41720_() instanceof CrossbowItem) {
                this.f_21345_.m_25352_(2, this.crossbowGoal);
            } else {
                this.f_21345_.m_25352_(2, (Goal)this.meleeGoal);
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGING_CROSSBOW, (Object)false);
    }

    protected void m_6851_(DifficultyInstance p_180481_1_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
    }

    public void m_8032_() {
        if (this.m_20069_()) {
            SoundEvent soundevent = this.m_7515_();
            if (soundevent != null) {
                this.m_5496_(soundevent, 0.5f, this.m_6100_());
            }
        } else {
            super.m_8032_();
        }
    }

    protected SoundEvent m_7515_() {
        return this.m_20069_() ? (SoundEvent)ModSoundEvents.SUNKEN_SKELETON_IDLE.get() : SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return this.m_20069_() ? (SoundEvent)ModSoundEvents.SUNKEN_SKELETON_HURT.get() : SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return this.m_20069_() ? (SoundEvent)ModSoundEvents.SUNKEN_SKELETON_DEATH.get() : SoundEvents.f_12424_;
    }

    protected SoundEvent m_7878_() {
        return SoundEvents.f_12383_;
    }

    protected SoundEvent m_5501_() {
        return (SoundEvent)ModSoundEvents.SUNKEN_SKELETON_STEP.get();
    }

    public void m_6136_(boolean chargingCrossbow) {
        this.f_19804_.m_135381_(CHARGING_CROSSBOW, (Object)chargingCrossbow);
    }

    public void m_5811_(LivingEntity target, ItemStack crossbow, Projectile projectile, float inaccuracy) {
        this.m_32322_((LivingEntity)this, target, projectile, inaccuracy, 1.6f);
    }

    public void m_32322_(LivingEntity p_234279_1_, LivingEntity p_234279_2_, Projectile p_234279_3_, float p_234279_4_, float p_234279_5_) {
        double d0 = p_234279_2_.m_20185_() - p_234279_1_.m_20185_();
        double d1 = p_234279_2_.m_20189_() - p_234279_1_.m_20189_();
        double d2 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1)));
        double d3 = p_234279_2_.m_20227_(0.3333333333333333) - p_234279_3_.m_20186_() + d2 * (double)0.2f;
        Vector3f vector3f = this.m_32332_(p_234279_1_, new Vec3(d0, d3, d1), p_234279_4_);
        p_234279_3_.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), p_234279_5_, (float)(14 - p_234279_1_.f_19853_.m_46791_().m_19028_() * 4));
        p_234279_1_.m_5496_(this.m_20069_() ? (SoundEvent)ModSoundEvents.SUNKEN_SKELETON_SHOOT.get() : SoundEvents.f_11847_, 1.0f, 1.0f / (p_234279_1_.m_21187_().nextFloat() * 0.4f + 0.8f));
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_6504_(LivingEntity target, float p_82196_2_) {
        if (this.m_21093_(itemStack -> itemStack.m_41720_() instanceof BowItem)) {
            super.m_6504_(target, p_82196_2_);
        } else {
            this.m_32336_((LivingEntity)this, 1.6f);
        }
    }

    public boolean m_5886_(ProjectileWeaponItem shootable) {
        return shootable instanceof BowItem || shootable instanceof CrossbowItem;
    }
}

