/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals.magic;

import com.infamous.dungeons_mobs.entities.magic.MagicType;
import com.infamous.dungeons_mobs.interfaces.IMagicUser;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class UseMagicGoal<T extends Mob>
extends Goal {
    private int magicWarmup;
    private int magicCooldown;
    private final T hostMobEntity;

    protected UseMagicGoal(T magicUserMob) {
        this.hostMobEntity = magicUserMob;
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.hostMobEntity.m_5448_();
        if (livingentity != null && livingentity.m_6084_()) {
            if (((IMagicUser)this.hostMobEntity).isUsingMagic()) {
                return false;
            }
            return ((Mob)this.hostMobEntity).f_19797_ >= this.magicCooldown;
        }
        return false;
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.hostMobEntity.m_5448_();
        return livingentity != null && livingentity.m_6084_() && this.magicWarmup > 0;
    }

    public void m_8056_() {
        this.magicWarmup = this.getMagicWarmupTime();
        ((IMagicUser)this.hostMobEntity).setMagicUseTicks(this.getMagicUseTime());
        this.magicCooldown = ((Mob)this.hostMobEntity).f_19797_ + this.getMagicUseInterval();
        SoundEvent soundevent = this.getMagicPrepareSound();
        if (soundevent != null) {
            this.hostMobEntity.m_5496_(soundevent, 1.0f, 1.0f);
        }
        ((IMagicUser)this.hostMobEntity).setMagicType(this.getMagicType());
    }

    public void m_8037_() {
        --this.magicWarmup;
        if (this.magicWarmup == 0) {
            this.useMagic();
            this.hostMobEntity.m_5496_(((IMagicUser)this.hostMobEntity).getMagicSound(), 1.0f, 1.0f);
        }
    }

    protected abstract void useMagic();

    private int getMagicWarmupTime() {
        return 20;
    }

    protected abstract int getMagicUseTime();

    protected abstract int getMagicUseInterval();

    @Nullable
    protected abstract SoundEvent getMagicPrepareSound();

    protected abstract MagicType getMagicType();
}

