/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.interfaces;

import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.raid.Raider;
import net.minecraftforge.common.BiomeDictionary;

public enum BiomeSpecificRaider {
    MOUNTAINEER((EntityType<? extends Raider>)((EntityType)ModEntityTypes.MOUNTAINEER.get()), (EntityType<? extends Raider>)EntityType.f_20493_, (List)DungeonsMobsConfig.COMMON.MOUNTAINEER_BIOME_TYPES.get()),
    ICEOLOGER((EntityType<? extends Raider>)((EntityType)ModEntityTypes.ICEOLOGER.get()), (EntityType<? extends Raider>)EntityType.f_20568_, (List)DungeonsMobsConfig.COMMON.ICEOLOGER_BIOME_TYPES.get()),
    WINDCALLER((EntityType<? extends Raider>)((EntityType)ModEntityTypes.WINDCALLER.get()), (EntityType<? extends Raider>)EntityType.f_20568_, (List)DungeonsMobsConfig.COMMON.WINDCALLER_BIOME_TYPES.get()),
    SQUALL_GOLEM((EntityType<? extends Raider>)((EntityType)ModEntityTypes.SQUALL_GOLEM.get()), (EntityType<? extends Raider>)EntityType.f_20518_, (List)DungeonsMobsConfig.COMMON.SQUALL_GOLEM_BIOME_TYPES.get());

    private final EntityType<? extends Raider> entityType;
    private final EntityType<? extends Raider> equivalentType;
    private final Set<BiomeDictionary.Type> biomeTypes = new HashSet<BiomeDictionary.Type>();

    private BiomeSpecificRaider(EntityType<? extends Raider> entityTypeIn, EntityType<? extends Raider> equivalentTypeIn, List<? extends String> biomeTypesList) {
        this.entityType = entityTypeIn;
        this.equivalentType = equivalentTypeIn;
        List filteredBiomesList = biomeTypesList.stream().filter(type -> !type.startsWith("!")).collect(Collectors.toList());
        for (BiomeDictionary.Type type2 : BiomeDictionary.Type.getAll()) {
            if (!filteredBiomesList.contains(type2.getName())) continue;
            this.biomeTypes.add(type2);
        }
    }

    public EntityType<? extends Raider> getType() {
        return this.entityType;
    }

    public EntityType<? extends Raider> getEquivalentType() {
        return this.equivalentType;
    }

    public Set<BiomeDictionary.Type> getBiomeTypeSet() {
        return this.biomeTypes;
    }
}

