/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Master;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionMasterHelper;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactUseContext;
import com.infamous.dungeons_libraries.items.interfaces.ISoulConsumer;
import com.infamous.dungeons_libraries.network.BreakItemMessage;
import com.infamous.dungeons_libraries.summon.SummonHelper;
import com.infamous.dungeons_libraries.utils.SoundHelper;
import com.infamous.dungeons_mobs.interfaces.IHasInventorySprite;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.network.NetworkHandler;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class NecromancerStaffItem
extends ArtifactItem
implements IHasInventorySprite,
ISoulConsumer {
    public NecromancerStaffItem(Item.Properties properties) {
        super(properties);
        this.procOnItemUse = true;
    }

    public InteractionResultHolder<ItemStack> procArtifact(ArtifactUseContext itemUseContext) {
        Master summonerCap;
        Level world = itemUseContext.getLevel();
        if (world.f_46443_ || itemUseContext.isHitMiss()) {
            return InteractionResultHolder.m_19090_((Object)itemUseContext.getItemStack());
        }
        ItemStack itemUseContextItem = itemUseContext.getItemStack();
        Player itemUseContextPlayer = itemUseContext.getPlayer();
        BlockPos itemUseContextPos = itemUseContext.getClickedPos();
        Direction itemUseContextFace = itemUseContext.getClickedFace();
        BlockState blockState = world.m_8055_(itemUseContextPos);
        BlockPos blockPos = blockState.m_60812_((BlockGetter)world, itemUseContextPos).m_83281_() ? itemUseContextPos : itemUseContextPos.m_142300_(itemUseContextFace);
        if (itemUseContextPlayer != null && (summonerCap = MinionMasterHelper.getMasterCapability((Entity)itemUseContextPlayer)) != null) {
            Entity summoned = SummonHelper.summonEntity((LivingEntity)itemUseContextPlayer, (BlockPos)itemUseContextPlayer.m_142538_(), (EntityType)EntityType.f_20501_);
            if (summoned != null) {
                SoundHelper.playCreatureSound((Entity)itemUseContextPlayer, (SoundEvent)((SoundEvent)ModSoundEvents.NECROMANCER_SUMMON.get()));
                itemUseContextItem.m_41622_(1, (LivingEntity)itemUseContextPlayer, entity -> NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new BreakItemMessage(entity.m_142049_(), itemUseContextItem)));
                ArtifactItem.putArtifactOnCooldown((Player)itemUseContextPlayer, (Item)itemUseContextItem.m_41720_());
            } else if (world instanceof ServerLevel) {
                List<Entity> zombieEntities = summonerCap.getSummonedMobs().stream().filter(entity -> entity.m_6095_() == EntityType.f_20501_).collect(Collectors.toList());
                zombieEntities.forEach(entity -> entity.m_20324_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.05, (double)blockPos.m_123343_() + 0.5));
            }
        }
        return InteractionResultHolder.m_19096_((Object)itemUseContextItem);
    }

    public int getCooldownInSeconds() {
        return 20;
    }

    public int getDurationInSeconds() {
        return 0;
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(int slotIndex) {
        return this.getAttributeModifiersForSlot(this.getUUIDForSlot(slotIndex));
    }

    private ImmutableMultimap<Attribute, AttributeModifier> getAttributeModifiersForSlot(UUID slot_uuid) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)((Attribute)AttributeRegistry.SUMMON_CAP.get()), (Object)new AttributeModifier(slot_uuid, "Artifact modifier", 3.0, AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    public float getActivationCost(ItemStack stack) {
        return 50.0f;
    }
}

